/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly.sp;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import java.util.Map;
import javax.servlet.ServletContext;
import org.picketlink.identity.federation.bindings.wildfly.sp.SPFormAuthenticationMechanism;
import org.picketlink.identity.federation.bindings.wildfly.sp.SecurityActions;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;

public class SPServletExtension
implements ServletExtension {
    private final SAMLConfigurationProvider configurationProvider;
    private final PicketLinkAuditHelper auditHelper;

    public SPServletExtension(SAMLConfigurationProvider configurationProvider, PicketLinkAuditHelper auditHelper) {
        this.configurationProvider = configurationProvider;
        this.auditHelper = auditHelper;
    }

    public SPServletExtension() {
        this(null, null);
    }

    public void handleDeployment(DeploymentInfo deploymentInfo, final ServletContext servletContext) {
        deploymentInfo.addAuthenticationMechanism("FORM", new AuthenticationMechanismFactory(){

            public AuthenticationMechanism create(String mechanismName, FormParserFactory formParserFactory, Map<String, String> properties) {
                SPFormAuthenticationMechanism authenticationMechanism = new SPFormAuthenticationMechanism(formParserFactory, mechanismName, properties.get("login_page"), properties.get("error_page"), servletContext, SPServletExtension.this.getConfigurationProvider(servletContext), SPServletExtension.this.getAuditHelper(servletContext));
                return authenticationMechanism;
            }
        });
    }

    private SAMLConfigurationProvider getConfigurationProvider(ServletContext servletContext) {
        String configProviderType = servletContext.getInitParameter("CONFIG_PROVIDER");
        if (configProviderType != null) {
            try {
                return (SAMLConfigurationProvider)SecurityActions.loadClass(Thread.currentThread().getContextClassLoader(), configProviderType).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create config provider [" + configProviderType + "].", e);
            }
        }
        return this.configurationProvider;
    }

    private PicketLinkAuditHelper getAuditHelper(ServletContext servletContext) {
        String auditHelperType = servletContext.getInitParameter("AUDIT_HELPER");
        if (auditHelperType != null) {
            try {
                return (PicketLinkAuditHelper)SecurityActions.loadClass(Thread.currentThread().getContextClassLoader(), auditHelperType).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create audit helper [" + auditHelperType + "].", e);
            }
        }
        return this.auditHelper;
    }
}

