/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.security.impl.authorization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import org.apache.deltaspike.security.api.authorization.AccessDecisionState;
import org.apache.deltaspike.security.api.authorization.SecurityViolation;
import org.apache.deltaspike.security.spi.authorization.EditableAccessDecisionVoterContext;

@RequestScoped
public class DefaultAccessDecisionVoterContext
implements EditableAccessDecisionVoterContext {
    private AccessDecisionState state = AccessDecisionState.INITIAL;
    private List<SecurityViolation> securityViolations;
    private Map<String, Object> metaData = new HashMap<String, Object>();
    private Object source;

    @Override
    public AccessDecisionState getState() {
        return this.state;
    }

    @Override
    public List<SecurityViolation> getViolations() {
        if (this.securityViolations == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.securityViolations);
    }

    @Override
    public <T> T getSource() {
        return (T)this.source;
    }

    @Override
    public void setSource(Object source) {
        this.source = source;
    }

    @Override
    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.metaData);
    }

    @Override
    public <T> T getMetaDataFor(String key, Class<T> targetType) {
        return (T)this.metaData.get(key);
    }

    @Override
    public void addMetaData(String key, Object metaData) {
        this.metaData.put(key, metaData);
    }

    @Override
    public void setState(AccessDecisionState accessDecisionVoterState) {
        if (AccessDecisionState.VOTE_IN_PROGRESS.equals((Object)accessDecisionVoterState)) {
            this.securityViolations = new ArrayList<SecurityViolation>();
        }
        this.state = accessDecisionVoterState;
        if (AccessDecisionState.INITIAL.equals((Object)accessDecisionVoterState) || AccessDecisionState.VOTE_IN_PROGRESS.equals((Object)accessDecisionVoterState)) {
            return;
        }
        this.metaData.clear();
    }

    @Override
    public void addViolation(SecurityViolation securityViolation) {
        if (this.securityViolations == null) {
            throw new IllegalStateException(AccessDecisionState.VOTE_IN_PROGRESS.name() + " is required for adding security-violations");
        }
        this.securityViolations.add(securityViolation);
    }
}

