/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.http.internal;

import java.security.Principal;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.picketlink.Identity;
import org.picketlink.authorization.util.AuthorizationUtil;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.model.annotation.StereotypeProperty;
import org.picketlink.internal.el.ELProcessor;

public class PicketLinkHttpServletRequest
extends HttpServletRequestWrapper {
    private final Identity identity;
    private final ELProcessor elProcessor;
    private final DefaultLoginCredentials credentials;
    private final PartitionManager partitionManager;
    private final String requestedUri;

    public PicketLinkHttpServletRequest(HttpServletRequest request, Identity identity, DefaultLoginCredentials credentials, PartitionManager partitionManager, ELProcessor elProcessor) {
        super(request);
        this.identity = identity;
        this.credentials = credentials;
        this.partitionManager = partitionManager;
        this.elProcessor = elProcessor;
        this.requestedUri = this.rewriteUri(request);
    }

    public void login(String username, String password) throws ServletException {
        this.credentials.setUserId(username);
        this.credentials.setPassword(password);
        this.identity.login();
    }

    public void logout() throws ServletException {
        if (this.isLoggedIn()) {
            this.identity.logout();
        }
        super.logout();
    }

    public Principal getUserPrincipal() {
        if (!this.isLoggedIn()) {
            return null;
        }
        return new Principal(){

            @Override
            public String getName() {
                List result = PropertyQueries.createQuery(PicketLinkHttpServletRequest.this.identity.getAccount().getClass()).addCriteria(new AnnotatedPropertyCriteria(StereotypeProperty.class)).getResultList();
                for (Property stereotypeProperty : result) {
                    Object userName;
                    StereotypeProperty stereotypePropertyAnnotation = stereotypeProperty.getAnnotatedElement().getAnnotation(StereotypeProperty.class);
                    if (!StereotypeProperty.Property.IDENTITY_USER_NAME.equals((Object)stereotypePropertyAnnotation.value()) || (userName = stereotypeProperty.getValue(PicketLinkHttpServletRequest.this.identity.getAccount())) == null) continue;
                    return userName.toString();
                }
                return null;
            }
        };
    }

    public String getRequestURI() {
        return this.requestedUri;
    }

    public boolean isUserInRole(String roleName) {
        if (this.isLoggedIn()) {
            return AuthorizationUtil.hasRole(this.identity, this.partitionManager, roleName);
        }
        return super.isUserInRole(roleName);
    }

    private boolean isLoggedIn() {
        return this.identity.isLoggedIn();
    }

    private String rewriteUri(HttpServletRequest request) {
        String requestedUri;
        String rewrittenUri = requestedUri = request.getRequestURI();
        if (requestedUri.indexOf(123) != -1) {
            StringBuilder template = null;
            for (int i = 0; i < requestedUri.length(); ++i) {
                char charAt = requestedUri.charAt(i);
                if (charAt == '{') {
                    template = new StringBuilder();
                    template.append(charAt);
                    continue;
                }
                if (template == null) continue;
                template.append(charAt);
                if (charAt != '}') continue;
                Object eval = this.elProcessor.eval("#" + template.toString());
                if (eval == null) break;
                String templateString = template.toString().replace("{", "\\{").replace("}", "\\}");
                rewrittenUri = rewrittenUri.replaceFirst(templateString, eval.toString());
                template = null;
            }
        }
        return rewrittenUri;
    }
}

