/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.http.internal.authorization;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.Identity;
import org.picketlink.config.http.AuthorizationConfiguration;
import org.picketlink.config.http.PathConfiguration;
import org.picketlink.http.authorization.PathAuthorizer;

public abstract class AbstractPathAuthorizer
implements PathAuthorizer {
    @Inject
    private Instance<Identity> identityInstance;

    @Override
    public boolean authorize(PathConfiguration pathConfiguration, HttpServletRequest request, HttpServletResponse response) {
        AuthorizationConfiguration authorizationConfiguration = pathConfiguration.getAuthorizationConfiguration();
        if (authorizationConfiguration == null) {
            return true;
        }
        return this.doAuthorize(pathConfiguration, request, response);
    }

    protected abstract boolean doAuthorize(PathConfiguration var1, HttpServletRequest var2, HttpServletResponse var3);

    protected Identity getIdentity() {
        return this.resolveInstance(this.identityInstance);
    }

    private <I> I resolveInstance(Instance<I> instance) {
        if (instance.isUnsatisfied()) {
            throw new IllegalStateException("Instance [" + instance + "] not found.");
        }
        if (instance.isAmbiguous()) {
            throw new IllegalStateException("Instance [" + instance + "] is ambiguous.");
        }
        try {
            return (I)instance.get();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not retrieve instance [" + instance + "].", e);
        }
    }
}

