/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.http.internal.authorization;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.Identity;
import org.picketlink.authorization.util.AuthorizationUtil;
import org.picketlink.config.http.AuthorizationConfiguration;
import org.picketlink.config.http.PathConfiguration;
import org.picketlink.http.internal.authorization.AbstractPathAuthorizer;
import org.picketlink.idm.PartitionManager;

public class GroupPathAuthorizer
extends AbstractPathAuthorizer {
    @Inject
    private PartitionManager partitionManager;

    @Override
    protected boolean doAuthorize(PathConfiguration pathConfiguration, HttpServletRequest request, HttpServletResponse response) {
        AuthorizationConfiguration authorizationConfiguration = pathConfiguration.getAuthorizationConfiguration();
        String[] allowedGroups = authorizationConfiguration.getAllowedGroups();
        if (allowedGroups != null) {
            Identity identity = this.getIdentity();
            for (String groupName : allowedGroups) {
                if (AuthorizationUtil.isMember(identity, this.partitionManager, groupName)) continue;
                return false;
            }
        }
        return true;
    }
}

