/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.picketlink.idm.file.internal.AbstractFileAttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;

public class FileIdentityType
extends AbstractFileAttributedType<IdentityType> {
    private static final String VERSION = "1";

    protected FileIdentityType(IdentityType object) {
        super(VERSION, object);
    }

    @Override
    protected IdentityType doPopulateEntry(Map<String, Serializable> properties) throws Exception {
        IdentityType identityType = (IdentityType)super.doPopulateEntry((Map)properties);
        String partitionType = properties.get("partitionType").toString();
        String partitionId = properties.get("partitionId").toString();
        Partition partition = (Partition)Class.forName(partitionType).getConstructor(String.class).newInstance("");
        partition.setId(partitionId);
        identityType.setPartition(partition);
        identityType.setCreatedDate((Date)properties.get("createdDate"));
        identityType.setExpirationDate((Date)properties.get("expirationDate"));
        identityType.setEnabled((Boolean)properties.get("enabled"));
        return identityType;
    }

    @Override
    protected void doPopulateProperties(Map<String, Serializable> properties) throws Exception {
        super.doPopulateProperties(properties);
        IdentityType identityType = (IdentityType)this.getEntry();
        if (identityType.getPartition() == null) {
            throw new IllegalStateException("Partition Null");
        }
        if (identityType.getPartition().getId() == null) {
            throw new IllegalStateException("Partition ID Null");
        }
        properties.put("partitionId", (Serializable)((Object)identityType.getPartition().getId()));
        properties.put("partitionType", (Serializable)((Object)identityType.getPartition().getClass().getName()));
        properties.put("createdDate", identityType.getCreatedDate());
        if (identityType.getExpirationDate() != null) {
            properties.put("expirationDate", identityType.getExpirationDate());
        }
        properties.put("enabled", Boolean.valueOf(identityType.isEnabled()));
    }
}

