/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.PropertyQuery;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.IdGenerator;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.PermissionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.event.CredentialUpdatedEvent;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.event.IdentityTypeCreatedEvent;
import org.picketlink.idm.event.IdentityTypeDeletedEvent;
import org.picketlink.idm.event.IdentityTypeUpdatedEvent;
import org.picketlink.idm.internal.AbstractIdentityContext;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.annotation.Unique;
import org.picketlink.idm.permission.Permission;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.IdentityQueryBuilder;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.internal.DefaultIdentityQuery;
import org.picketlink.idm.query.internal.DefaultQueryBuilder;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.StoreSelector;
import org.picketlink.idm.util.IDMUtil;

public class ContextualIdentityManager
extends AbstractIdentityContext
implements IdentityManager {
    private final StoreSelector storeSelector;
    private final RelationshipManager relationshipManager;
    private final PermissionManager permissionManager;

    public ContextualIdentityManager(Partition partition, EventBridge eventBridge, IdGenerator idGenerator, StoreSelector storeSelector, RelationshipManager relationshipManager, PermissionManager permissionManager) {
        super(partition, eventBridge, idGenerator);
        this.storeSelector = storeSelector;
        this.setParameter("IDENTITY_MANAGER_CTX_PARAMETER", this);
        this.relationshipManager = relationshipManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public void add(IdentityType identityType) throws IdentityManagementException {
        this.checkUniqueness(identityType);
        try {
            IdentityStore identityStore = this.storeSelector.getStoreForIdentityOperation(this, IdentityStore.class, identityType.getClass(), IdentityStoreConfiguration.IdentityOperation.create);
            identityStore.add(this, identityType);
            IDMUtil.configureDefaultPartition(identityType, identityStore, this.getPartitionManager());
            this.addAttributes(identityType);
            this.getEventBridge().raiseEvent(new IdentityTypeCreatedEvent(identityType, this.getPartitionManager()));
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.attributedTypeAddFailed(identityType, e);
        }
    }

    @Override
    public void update(IdentityType identityType) throws IdentityManagementException {
        this.checkIfIdentityTypeExists(identityType);
        try {
            this.storeSelector.getStoreForIdentityOperation(this, IdentityStore.class, identityType.getClass(), IdentityStoreConfiguration.IdentityOperation.update).update(this, identityType);
            if (identityType.getPartition() == null) {
                throw IDMInternalMessages.MESSAGES.attributedUndefinedPartition(identityType);
            }
            this.removeAttributes(identityType);
            this.addAttributes(identityType);
            this.getEventBridge().raiseEvent(new IdentityTypeUpdatedEvent(identityType, this.getPartitionManager()));
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.attributedTypeUpdateFailed(identityType, e);
        }
    }

    @Override
    public void remove(IdentityType identityType) throws IdentityManagementException {
        this.checkIfIdentityTypeExists(identityType);
        try {
            RelationshipQuery<Relationship> query = this.relationshipManager.createRelationshipQuery(Relationship.class);
            query.setParameter(Relationship.IDENTITY, identityType);
            for (Relationship relationship : query.getResultList()) {
                this.relationshipManager.remove(relationship);
            }
            if (this.permissionManager != null) {
                List<Permission> permissions = this.permissionManager.listPermissions(identityType);
                for (Permission permission : permissions) {
                    this.permissionManager.revokePermission(identityType, permission.getResourceClass(), permission.getOperation());
                }
            }
            this.removeAllAttributes(identityType);
            this.storeSelector.getStoreForIdentityOperation(this, IdentityStore.class, identityType.getClass(), IdentityStoreConfiguration.IdentityOperation.delete).remove(this, identityType);
            this.getEventBridge().raiseEvent(new IdentityTypeDeletedEvent(identityType, this.getPartitionManager()));
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.attributedTypeRemoveFailed(identityType, e);
        }
    }

    @Override
    public <T extends IdentityType> T lookupIdentityById(Class<T> identityType, String id) {
        if (identityType == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("IdentityType class");
        }
        if (id == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Identifier");
        }
        IdentityQueryBuilder queryBuilder = this.getQueryBuilder();
        IdentityQuery query = queryBuilder.createIdentityQuery(identityType);
        query.where(queryBuilder.equal(IdentityType.ID, id));
        List result = query.getResultList();
        IdentityType identity = null;
        if (!result.isEmpty()) {
            if (result.size() > 1) {
                throw IDMInternalMessages.MESSAGES.attributedTypeAmbiguosFoundWithId(id);
            }
            identity = (IdentityType)result.get(0);
        }
        return (T)identity;
    }

    @Override
    public <T extends IdentityType> IdentityQuery<T> createIdentityQuery(Class<T> identityType) {
        if (identityType == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("IdentityType class");
        }
        return new DefaultIdentityQuery<T>(this.getQueryBuilder(), this, identityType, this.storeSelector);
    }

    @Override
    public void validateCredentials(Credentials credentials) {
        if (credentials == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Credentials");
        }
        try {
            this.storeSelector.getStoreForCredentialOperation(this, credentials.getClass()).validateCredentials(this, credentials);
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.credentialValidationFailed(credentials, e);
        }
    }

    @Override
    public void updateCredential(Account account, Object credential) {
        this.updateCredential(account, credential, null, null);
    }

    @Override
    public void updateCredential(Account account, Object credential, Date effectiveDate, Date expiryDate) {
        this.checkIfIdentityTypeExists(account);
        if (credential == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Credential");
        }
        try {
            this.storeSelector.getStoreForCredentialOperation(this, credential.getClass()).updateCredential(this, account, credential, effectiveDate, expiryDate);
            this.getEventBridge().raiseEvent(new CredentialUpdatedEvent(account, credential, effectiveDate, expiryDate, this.getPartitionManager()));
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.credentialUpdateFailed(account, credential, e);
        }
    }

    @Override
    public <T extends CredentialStorage> T retrieveCurrentCredential(Account account, Class<T> storageClass) {
        this.checkIfIdentityTypeExists(account);
        if (storageClass == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("CredentialStorage type");
        }
        try {
            for (CredentialStore<?> credentialStore : this.storeSelector.getStoresForCredentialStorage(this, storageClass)) {
                Object credentialStorage = credentialStore.retrieveCurrentCredential(this, account, storageClass);
                if (credentialStorage == null) continue;
                return (T)credentialStorage;
            }
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.credentialRetrievalFailed(account, storageClass, e);
        }
        return null;
    }

    @Override
    public <T extends CredentialStorage> List<T> retrieveCredentials(Account account, Class<T> storageClass) {
        this.checkIfIdentityTypeExists(account);
        if (storageClass == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("CredentialStorage type");
        }
        ArrayList storages = new ArrayList();
        try {
            for (CredentialStore<?> credentialStore : this.storeSelector.getStoresForCredentialStorage(this, storageClass)) {
                storages.addAll(credentialStore.retrieveCredentials(this, account, storageClass));
            }
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.credentialRetrievalFailed(account, storageClass, e);
        }
        return storages;
    }

    @Override
    public void removeCredential(Account account, Class<? extends CredentialStorage> storageClass) {
        this.checkIfIdentityTypeExists(account);
        if (storageClass == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("CredentialStorage type");
        }
        try {
            for (CredentialStore<?> credentialStore : this.storeSelector.getStoresForCredentialStorage(this, storageClass)) {
                credentialStore.removeCredential(this, account, storageClass);
            }
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.credentialRetrievalFailed(account, storageClass, e);
        }
    }

    @Override
    public IdentityQueryBuilder getQueryBuilder() {
        return new DefaultQueryBuilder(this, this.storeSelector);
    }

    private void checkUniqueness(IdentityType identityType) {
        if (identityType == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("IdentityType");
        }
        PropertyQuery propertyQuery = PropertyQueries.createQuery(identityType.getClass());
        propertyQuery.addCriteria(new AnnotatedPropertyCriteria(Unique.class));
        IdentityQueryBuilder queryBuilder = this.getQueryBuilder();
        IdentityQuery identityQuery = queryBuilder.createIdentityQuery(identityType.getClass());
        for (Property property : propertyQuery.getResultList()) {
            identityQuery.where(queryBuilder.equal(AttributedType.QUERY_ATTRIBUTE.byName(property.getName()), property.getValue(identityType)));
        }
        List result = identityQuery.getResultList();
        if (!result.isEmpty()) {
            for (Property property : propertyQuery.getResultList()) {
                for (IdentityType storedType : result) {
                    if (!((Serializable)property.getValue(storedType)).equals(property.getValue(identityType))) continue;
                    throw IDMInternalMessages.MESSAGES.identityTypeAlreadyExists(identityType.getClass(), identityType.getId(), this.getPartition());
                }
            }
        }
    }

    private void checkIfIdentityTypeExists(IdentityType identityType) throws IdentityManagementException {
        if (identityType == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("IdentityType");
        }
        if (this.lookupIdentityById(identityType.getClass(), identityType.getId()) == null) {
            throw IDMInternalMessages.MESSAGES.attributedTypeNotFoundWithId(identityType.getClass(), identityType.getId(), this.getPartition());
        }
    }

    private void removeAllAttributes(IdentityType identityType) {
        Object storedType;
        Object attributeStore = this.storeSelector.getStoreForAttributeOperation(this);
        if (attributeStore != null && (storedType = this.lookupIdentityById(identityType.getClass(), identityType.getId())) != null) {
            for (Attribute<? extends Serializable> attribute : storedType.getAttributes()) {
                attributeStore.removeAttribute(this, identityType, attribute.getName());
            }
        }
    }

    private void addAttributes(IdentityType identityType) {
        Object attributeStore = this.storeSelector.getStoreForAttributeOperation(this);
        if (attributeStore != null) {
            for (Attribute<? extends Serializable> attribute : identityType.getAttributes()) {
                attributeStore.setAttribute(this, identityType, attribute);
            }
        }
    }

    private void removeAttributes(IdentityType identityType) {
        Object storedType;
        Object attributeStore = this.storeSelector.getStoreForAttributeOperation(this);
        if (attributeStore != null && (storedType = this.lookupIdentityById(identityType.getClass(), identityType.getId())) != null) {
            for (Attribute<? extends Serializable> attribute : storedType.getAttributes()) {
                if (identityType.getAttribute(attribute.getName()) != null) continue;
                attributeStore.removeAttribute(this, identityType, attribute.getName());
            }
        }
    }

    private PartitionManager getPartitionManager() {
        return (PartitionManager)((Object)this.storeSelector);
    }
}

