/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.io.Serializable;
import java.util.List;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdGenerator;
import org.picketlink.idm.PermissionManager;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.internal.AbstractIdentityContext;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.permission.Permission;
import org.picketlink.idm.permission.acl.spi.PermissionHandlerPolicy;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.StoreSelector;

public class ContextualPermissionManager
extends AbstractIdentityContext
implements PermissionManager {
    private final StoreSelector storeSelector;

    public ContextualPermissionManager(Partition partition, EventBridge eventBridge, IdGenerator idGenerator, PermissionHandlerPolicy permissionHandlerPolicy, StoreSelector storeSelector) {
        super(partition, eventBridge, idGenerator, permissionHandlerPolicy);
        this.storeSelector = storeSelector;
    }

    @Override
    public List<Permission> listPermissions(Object resource) {
        return this.storeSelector.getStoreForPermissionOperation(this).listPermissions((IdentityContext)this, resource);
    }

    @Override
    public List<Permission> listPermissions(Class<?> resourceClass, Serializable identifier) {
        return this.storeSelector.getStoreForPermissionOperation(this).listPermissions((IdentityContext)this, resourceClass, identifier);
    }

    @Override
    public List<Permission> listPermissions(Class<?> resourceClass, Serializable identifier, String operation) {
        return this.storeSelector.getStoreForPermissionOperation(this).listPermissions(this, resourceClass, identifier, operation);
    }

    @Override
    public List<Permission> listPermissions(Object resource, String operation) {
        return this.storeSelector.getStoreForPermissionOperation(this).listPermissions((IdentityContext)this, resource, operation);
    }

    @Override
    public List<Permission> listPermissions(Class<?> resource, String operation) {
        return this.storeSelector.getStoreForPermissionOperation(this).listPermissions((IdentityContext)this, resource, operation);
    }

    @Override
    public List<Permission> listPermissions(IdentityType identityType) {
        return this.storeSelector.getStoreForPermissionOperation(this).listPermissions((IdentityContext)this, identityType);
    }

    @Override
    public void grantPermission(IdentityType assignee, Object resource, String operation) {
        try {
            this.storeSelector.getStoreForPermissionOperation(this).grantPermission(this, assignee, resource, operation);
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.permissionGrantFailed(assignee, resource, operation, e);
        }
    }

    @Override
    public void revokePermission(IdentityType assignee, Object resource, String operation) {
        try {
            this.storeSelector.getStoreForPermissionOperation(this).revokePermission(this, assignee, resource, operation);
        }
        catch (Exception ex) {
            throw IDMMessages.MESSAGES.permissionRevokeFailed(assignee, resource, operation, ex);
        }
    }

    @Override
    public void revokePermission(IdentityType assignee, Class<?> resourceclass, String operation) {
        try {
            this.storeSelector.getStoreForPermissionOperation(this).revokePermission(this, assignee, resourceclass, operation);
        }
        catch (Exception ex) {
            throw IDMMessages.MESSAGES.permissionRevokeFailed(assignee, resourceclass, operation, ex);
        }
    }

    @Override
    public void clearPermissions(Object resource) {
        try {
            this.storeSelector.getStoreForPermissionOperation(this).revokeAllPermissions(this, resource);
        }
        catch (Exception ex) {
            throw IDMMessages.MESSAGES.permissionRevokeAllFailed(resource, ex);
        }
    }
}

