/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal.util;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.permission.Permission;

public class PermissionUtil {
    public static String addOperation(String operationsCSV, String operation) {
        Set<String> ops = PermissionUtil.asOperationList(operationsCSV);
        for (String newOperation : PermissionUtil.asOperationList(operation)) {
            if (ops.contains(newOperation)) continue;
            ops.add(newOperation);
        }
        return PermissionUtil.asOperationCSV(ops);
    }

    public static String removeOperation(String operationsCSV, String operation) {
        Set<String> ops = PermissionUtil.asOperationList(operationsCSV);
        for (String opToRemove : PermissionUtil.asOperationList(operation)) {
            ops.remove(opToRemove);
        }
        return PermissionUtil.asOperationCSV(ops);
    }

    public static Set<String> asOperationList(String operationsCSV) {
        HashSet<String> operations = new HashSet<String>();
        if (!StringUtil.isNullOrEmpty(operationsCSV)) {
            for (String operation : operationsCSV.split(",")) {
                operations.add(operation.trim());
            }
        }
        return operations;
    }

    public static boolean hasAttributes(Permission permission, Class<?> resourceClass, Serializable identifier, String operation) {
        if (!permission.getResourceClass().equals(resourceClass)) {
            return false;
        }
        if (!permission.getResourceIdentifier().toString().equals(identifier.toString()) && !identifier.equals(resourceClass.getName())) {
            return false;
        }
        return PermissionUtil.hasOperation(permission, operation);
    }

    public static boolean hasOperation(Permission permission, String operation) {
        String operationToCheck = operation;
        if (operationToCheck == null) {
            operationToCheck = "*";
        }
        for (String op : PermissionUtil.asOperationList(permission.getOperation())) {
            for (String opCheck : PermissionUtil.asOperationList(operationToCheck)) {
                if (!"*".equals(opCheck.trim()) && !op.trim().equals(opCheck.trim())) continue;
                return true;
            }
        }
        return false;
    }

    private static String asOperationCSV(Set<String> ops) {
        StringBuilder sb = new StringBuilder();
        for (String op : ops) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(op);
        }
        return sb.toString();
    }
}

