/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jdbc.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.jdbc.internal.model.AbstractJdbcType;
import org.picketlink.idm.jdbc.internal.model.db.PartitionStorageUtil;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.query.AttributeParameter;
import org.picketlink.idm.query.QueryParameter;

public class PartitionJdbcType
extends AbstractJdbcType
implements Partition {
    protected String name;
    protected String typeName;
    protected String configurationName;

    public PartitionJdbcType() {
    }

    public PartitionJdbcType(String name) {
        this.name = name;
    }

    public PartitionJdbcType setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public PartitionJdbcType setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public PartitionJdbcType setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
        return this;
    }

    @Override
    public void setAttribute(Attribute<? extends Serializable> attribute) {
        throw IDMMessages.MESSAGES.unexpectedType(attribute.getClass());
    }

    @Override
    public void removeAttribute(String name) {
        throw new RuntimeException();
    }

    @Override
    public <T extends Serializable> Attribute<T> getAttribute(String name) {
        throw new RuntimeException();
    }

    @Override
    public Collection<Attribute<? extends Serializable>> getAttributes() {
        if (this.dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void delete(AttributedType attributedType) {
        throw IDMMessages.MESSAGES.unexpectedType(attributedType.getClass());
    }

    @Override
    public void deleteRelationships(AttributedType attributedType) {
        throw IDMMessages.MESSAGES.unexpectedType(attributedType.getClass());
    }

    @Override
    public void persist(AttributedType attributedType) {
        PartitionJdbcType partition = (PartitionJdbcType)attributedType;
        if (this.load(partition.getId(), partition) == null) {
            PartitionStorageUtil partitionStorageUtil = new PartitionStorageUtil();
            partitionStorageUtil.storePartition(this.dataSource, partition);
        }
    }

    @Override
    public AttributedType load(String id, AttributedType attributedType) {
        PartitionStorageUtil partitionStorageUtil = new PartitionStorageUtil();
        return partitionStorageUtil.loadPartitionById(this.dataSource, id);
    }

    @Override
    public AttributedType load(String id, Class<? extends AttributedType> attributedType) {
        PartitionStorageUtil partitionStorageUtil = new PartitionStorageUtil();
        return partitionStorageUtil.loadPartitionById(this.dataSource, id);
    }

    @Override
    public List<? extends AttributedType> load(Map<QueryParameter, Object[]> params, Class<? extends AttributedType> attributedType) {
        ArrayList<Partition> result = new ArrayList<Partition>();
        Object[] name = this.getValuesFromParamMap(params, new AttributeParameter("name"));
        PartitionStorageUtil partitionStorageUtil = new PartitionStorageUtil();
        result.add(partitionStorageUtil.loadPartitionByName(this.dataSource, (String)name[0]));
        return result;
    }

    @Override
    public void update(AttributedType attributedType) {
        throw IDMMessages.MESSAGES.unexpectedType(attributedType.getClass());
    }
}

