/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jdbc.internal.model.db;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.jdbc.internal.model.PartitionJdbcType;
import org.picketlink.idm.jdbc.internal.model.db.AbstractStorageUtil;
import org.picketlink.idm.jdbc.internal.model.db.AttributeStorageUtil;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.basic.Role;
import org.picketlink.idm.query.AttributeParameter;
import org.picketlink.idm.query.QueryParameter;

public class RoleStorageUtil
extends AbstractStorageUtil {
    public void deleteRole(DataSource dataSource, Role role) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = dataSource.getConnection();
            String sql = "delete from Role where id=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, role.getId());
            int result = preparedStatement.executeUpdate();
            if (result == 0) {
                throw new RuntimeException("Delete Role failed");
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(preparedStatement);
        this.safeClose(connection);
    }

    public Role loadRole(DataSource dataSource, String id) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block9: {
            Role role;
            if (dataSource == null) {
                throw IDMMessages.MESSAGES.nullArgument("datasource");
            }
            connection = null;
            preparedStatement = null;
            resultSet = null;
            try {
                AttributeStorageUtil attributeStorageUtil;
                List<Attribute> attributeList;
                Timestamp expirationDate;
                connection = dataSource.getConnection();
                String sql = "select name,partitionID,enabled,createdDate,expirationDate from Role where id =?";
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, id);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block9;
                Role role2 = new Role();
                role2.setName(resultSet.getString(1));
                role2.setId(id);
                role2.setPartition(this.loadPartition(dataSource, resultSet.getString(2)));
                role2.setEnabled("y".equalsIgnoreCase(resultSet.getString(3)));
                Timestamp creationDate = resultSet.getTimestamp(4);
                if (creationDate != null) {
                    role2.setCreatedDate(new java.util.Date(creationDate.getTime()));
                }
                if ((expirationDate = resultSet.getTimestamp(5)) != null) {
                    role2.setExpirationDate(new java.util.Date(expirationDate.getTime()));
                }
                if (!(attributeList = (attributeStorageUtil = new AttributeStorageUtil()).getAttributes(dataSource, role2.getId())).isEmpty()) {
                    for (Attribute attribute : attributeList) {
                        role2.setAttribute(attribute);
                    }
                }
                role = role2;
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.safeClose(resultSet);
                    this.safeClose(preparedStatement);
                    this.safeClose(connection);
                    throw throwable;
                }
            }
            this.safeClose(resultSet);
            this.safeClose(preparedStatement);
            this.safeClose(connection);
            return role;
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return null;
    }

    public Role loadRole(DataSource dataSource, Map<QueryParameter, Object[]> params) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        Set<QueryParameter> queryParameters = params.keySet();
        for (QueryParameter queryParameter : queryParameters) {
            if (!(queryParameter instanceof AttributeParameter)) continue;
            AttributeParameter attributeParameter = (AttributeParameter)queryParameter;
            Object[] paramValues = this.getValuesFromParamMap(params, attributeParameter);
            String attributeName = attributeParameter.getName();
            if ("name".equals(attributeName)) {
                String loginNameValue = (String)paramValues[0];
                return this.loadRoleByName(dataSource, loginNameValue);
            }
            throw new RuntimeException();
        }
        throw new RuntimeException();
    }

    public Role loadRoleByName(DataSource dataSource, String roleName) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block9: {
            Role role;
            if (dataSource == null) {
                throw IDMMessages.MESSAGES.nullArgument("datasource");
            }
            connection = null;
            preparedStatement = null;
            resultSet = null;
            try {
                AttributeStorageUtil attributeStorageUtil;
                List<Attribute> attributeList;
                Timestamp expirationDate;
                connection = dataSource.getConnection();
                String sql = "select id,partitionID,enabled,createdDate,expirationDate from Role where name =?";
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, roleName);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block9;
                Role role2 = new Role();
                role2.setId(resultSet.getString(1));
                role2.setName(roleName);
                role2.setPartition(this.loadPartition(dataSource, resultSet.getString(2)));
                role2.setEnabled("y".equalsIgnoreCase(resultSet.getString(3)));
                Timestamp creationDate = resultSet.getTimestamp(4);
                if (creationDate != null) {
                    role2.setCreatedDate(new java.util.Date(creationDate.getTime()));
                }
                if ((expirationDate = resultSet.getTimestamp(5)) != null) {
                    role2.setExpirationDate(new java.util.Date(expirationDate.getTime()));
                }
                if (!(attributeList = (attributeStorageUtil = new AttributeStorageUtil()).getAttributes(dataSource, role2.getId())).isEmpty()) {
                    for (Attribute attribute : attributeList) {
                        role2.setAttribute(attribute);
                    }
                }
                role = role2;
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.safeClose(resultSet);
                    this.safeClose(preparedStatement);
                    this.safeClose(connection);
                    throw throwable;
                }
            }
            this.safeClose(resultSet);
            this.safeClose(preparedStatement);
            this.safeClose(connection);
            return role;
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return null;
    }

    public void storeRole(DataSource dataSource, Role role) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            int result;
            connection = dataSource.getConnection();
            String sql = "insert into Role set name=?,id=?,createdDate=?,expirationDate=?,partitionID=?,enabled=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, role.getName());
            preparedStatement.setString(2, role.getId());
            preparedStatement.setTimestamp(3, new Timestamp(role.getCreatedDate().getTime()));
            if (role.getExpirationDate() != null) {
                preparedStatement.setTimestamp(4, new Timestamp(role.getExpirationDate().getTime()));
            } else {
                preparedStatement.setTimestamp(4, null);
            }
            preparedStatement.setString(5, role.getPartition().getId());
            if (role.isEnabled()) {
                preparedStatement.setString(6, "y");
            }
            if ((result = preparedStatement.executeUpdate()) == 0) {
                throw new RuntimeException("Insert into Role failed");
            }
            PartitionJdbcType pj = new PartitionJdbcType("dummy");
            pj.setDataSource(dataSource);
            pj.persist(role.getPartition());
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(preparedStatement);
        this.safeClose(connection);
    }

    public void updateRole(DataSource dataSource, Role role) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        String updateSql = "update Role set name=?,enabled=?,createdDate=?,expirationDate=? where id =?";
        if (role.getExpirationDate() == null) {
            updateSql = "update Role set name=?,enabled=?,createdDate=? where id =?";
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            preparedStatement = connection.prepareStatement(updateSql);
            preparedStatement.setString(1, role.getName());
            if (role.isEnabled()) {
                preparedStatement.setString(2, "y");
            } else {
                preparedStatement.setString(2, "n");
            }
            preparedStatement.setDate(3, new Date(role.getCreatedDate().getTime()));
            if (role.getExpirationDate() != null) {
                preparedStatement.setTimestamp(4, new Timestamp(role.getExpirationDate().getTime()));
                preparedStatement.setString(5, role.getId());
            } else {
                preparedStatement.setString(4, role.getId());
            }
            int numberOfRows = preparedStatement.executeUpdate();
            if (numberOfRows == 0) {
                System.out.println("Update Role failed");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.safeClose(resultSet);
            this.safeClose(preparedStatement);
            this.safeClose(connection);
        }
    }
}

