/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal.mappers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.jpa.internal.mappers.EntityMapping;
import org.picketlink.idm.jpa.internal.mappers.ModelMapper;

public abstract class AbstractModelMapper
implements ModelMapper {
    @Override
    public List<EntityMapping> createMapping(Class<?> entityType) {
        if (!this.supports(entityType)) {
            return Collections.emptyList();
        }
        if (Modifier.isAbstract(entityType.getModifiers())) {
            throw new IdentityManagementException("Mapped entity [" + entityType + "] is marked as abstract.");
        }
        try {
            return this.doCreateMapping(entityType);
        }
        catch (Exception e) {
            throw new IdentityManagementException("Could not map entity [" + entityType + "].", e);
        }
    }

    protected abstract List<EntityMapping> doCreateMapping(Class<?> var1) throws SecurityConfigurationException;

    protected Property getAnnotatedProperty(Class<? extends Annotation> annotationType, Class<?> type) {
        return PropertyQueries.createQuery(type).addCriteria(new AnnotatedPropertyCriteria(annotationType)).getFirstResult();
    }

    protected List<Property<String>> getAnnotatedProperties(Class<? extends Annotation> annotationType, Class<?> type) {
        return PropertyQueries.createQuery(type).addCriteria(new AnnotatedPropertyCriteria(annotationType)).getResultList();
    }

    protected Property getNamedProperty(String propertyName, Class<?> type) {
        return PropertyQueries.createQuery(type).addCriteria(new NamedPropertyCriteria(propertyName)).getFirstResult();
    }
}

