/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.EntityType;
import org.picketlink.annotations.PicketLink;
import org.picketlink.log.BaseLog;

public class EntityManagerProvider {
    private static final String JPA_ANNOTATION_PACKAGE = "org.picketlink.idm.jpa.annotations";
    @Inject
    @Any
    private Instance<EntityManager> entityManagerInstance;
    private Class<?>[] mappedEntities;

    @Inject
    public void init() {
        this.mappedEntities = this.resolveMappedEntities();
    }

    public EntityManager getEntityManager() {
        if (!this.entityManagerInstance.isUnsatisfied()) {
            Instance picketLinkEntityManager = this.entityManagerInstance.select(new Annotation[]{new AnnotationLiteral<PicketLink>(){}});
            if (!picketLinkEntityManager.isUnsatisfied()) {
                return (EntityManager)picketLinkEntityManager.get();
            }
            return (EntityManager)this.entityManagerInstance.get();
        }
        return null;
    }

    public Class<?>[] getMappedEntities() {
        return this.mappedEntities;
    }

    public boolean hasMappedEntities() {
        return this.resolveMappedEntities().length != 0;
    }

    private Class<?>[] resolveMappedEntities() {
        HashSet<Class> entities = new HashSet<Class>();
        EntityManager entityManager = this.getEntityManager();
        if (entityManager != null) {
            for (EntityType entityType : entityManager.getMetamodel().getEntities()) {
                Class javaType = entityType.getJavaType();
                if (javaType == null || Modifier.isAbstract(javaType.getModifiers()) || !this.isMappedEntity(javaType)) continue;
                if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                    BaseLog.ROOT_LOGGER.debugf("PicketLink IDM mapped entity found [%s].", entityType);
                }
                entities.add(javaType);
            }
        }
        return entities.toArray(new Class[entities.size()]);
    }

    private boolean isMappedEntity(Class<?> cls) {
        while (!cls.equals(Object.class)) {
            for (Annotation a : cls.getAnnotations()) {
                if (!a.annotationType().getName().startsWith(JPA_ANNOTATION_PACKAGE)) continue;
                return true;
            }
            for (Field f : cls.getDeclaredFields()) {
                for (Annotation a : f.getAnnotations()) {
                    if (!a.annotationType().getName().startsWith(JPA_ANNOTATION_PACKAGE)) continue;
                    return true;
                }
            }
            cls = cls.getSuperclass();
        }
        return false;
    }
}

