/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.concurrent.ConcurrentHashMap;
import org.resteasy.Failure;
import org.resteasy.PathParamIndex;
import org.resteasy.ResourceInvoker;
import org.resteasy.ResourceMethod;
import org.resteasy.ResourceMethodRegistry;
import org.resteasy.specimpl.PathSegmentImpl;
import org.resteasy.specimpl.UriInfoImpl;
import org.resteasy.spi.HttpRequest;
import org.resteasy.spi.HttpResponse;
import org.resteasy.spi.InjectorFactory;
import org.resteasy.spi.MethodInjector;
import org.resteasy.spi.ResourceFactory;
import org.resteasy.spi.ResteasyProviderFactory;
import org.resteasy.util.GetRestful;

public class ResourceLocator
implements ResourceInvoker {
    protected InjectorFactory injector;
    protected MethodInjector methodInjector;
    protected ResourceFactory resource;
    protected ResteasyProviderFactory providerFactory;
    protected Method method;
    protected ConcurrentHashMap<Class, ResourceMethodRegistry> cachedSubresources = new ConcurrentHashMap();
    protected int uriIndex;
    protected PathParamIndex index;
    protected boolean limited;

    public ResourceLocator(ResourceFactory resource, InjectorFactory injector, ResteasyProviderFactory providerFactory, Method method, PathParamIndex index, boolean limited) {
        this.resource = resource;
        this.injector = injector;
        this.providerFactory = providerFactory;
        this.method = method;
        this.methodInjector = injector.createMethodInjector(method);
        this.index = index;
        this.limited = limited;
    }

    public void setUriIndex(int uriIndex) {
        this.uriIndex = uriIndex;
    }

    protected Object createResource(HttpRequest request, HttpResponse response) {
        Object resource = this.resource.createResource(request, response, this.injector);
        return this.createResource(request, response, resource);
    }

    protected Object createResource(HttpRequest request, HttpResponse response, Object locator) {
        UriInfoImpl uriInfo = (UriInfoImpl)request.getUri();
        this.index.populateUriInfoTemplateParams(request);
        Object[] args = this.methodInjector.injectArguments(request, response);
        try {
            Object subResource = this.method.invoke(locator, args);
            uriInfo.pushCurrentResource(locator);
            return subResource;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void setAncestorUri(UriInfoImpl uriInfo) {
        StringBuffer encoded = new StringBuffer();
        boolean first = true;
        for (int i = this.index.getOffset(); i < this.uriIndex + this.index.getOffset(); ++i) {
            if (first) {
                first = false;
            } else {
                encoded.append("/");
            }
            PathSegmentImpl encodedSegment = (PathSegmentImpl)uriInfo.getPathSegments(false).get(i);
            encoded.append(encodedSegment.getOriginal());
        }
        String encodedUri = encoded.toString();
        try {
            String decodedUri = URLDecoder.decode(encodedUri, "UTF-8");
            uriInfo.pushAncestorURI(encodedUri, decodedUri);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(HttpRequest request, HttpResponse response) throws IOException {
        UriInfoImpl uriInfo = (UriInfoImpl)request.getUri();
        try {
            Object target = this.createResource(request, response);
            this.setAncestorUri(uriInfo);
            this.invokeOnTargetObject(request, response, target);
        }
        finally {
            uriInfo.popCurrentResource();
            uriInfo.popAncestorURI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(HttpRequest request, HttpResponse response, Object locator) throws IOException {
        UriInfoImpl uriInfo = (UriInfoImpl)request.getUri();
        try {
            Object target = this.createResource(request, response, locator);
            this.setAncestorUri(uriInfo);
            this.invokeOnTargetObject(request, response, target);
        }
        finally {
            uriInfo.popCurrentResource();
            uriInfo.popAncestorURI();
        }
    }

    protected void invokeOnTargetObject(HttpRequest request, HttpResponse response, Object target) throws IOException {
        ResourceInvoker invoker;
        ResourceMethodRegistry registry = this.cachedSubresources.get(target.getClass());
        if (registry == null) {
            registry = new ResourceMethodRegistry(this.providerFactory);
            Class subResourceClass = GetRestful.getSubResourceClass(target.getClass());
            if (subResourceClass == null) {
                String msg = "Subresource class has no jax-rs annotations.: " + subResourceClass.getName();
                throw new Failure(msg, 500);
            }
            registry.addResourceFactory(null, null, subResourceClass, this.uriIndex + this.index.getOffset(), this.limited);
            this.cachedSubresources.putIfAbsent(target.getClass(), registry);
        }
        if ((invoker = registry.getResourceInvoker(request, response, this.uriIndex + this.index.getOffset(), this.limited)) instanceof ResourceLocator) {
            ResourceLocator locator = (ResourceLocator)invoker;
            locator.invoke(request, response, target);
        } else {
            ResourceMethod method = (ResourceMethod)invoker;
            method.invoke(request, response, target);
        }
    }
}

