/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy.plugins.server.grizzly;

import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.util.http.Cookie;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import org.resteasy.Headers;
import org.resteasy.specimpl.HttpHeadersImpl;
import org.resteasy.specimpl.MultivaluedMapImpl;
import org.resteasy.util.MediaTypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyUtils {
    public static MultivaluedMapImpl<String, String> extractParameters(GrizzlyRequest request) {
        MultivaluedMapImpl<String, String> parameters = new MultivaluedMapImpl<String, String>();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            for (String parameterValue : request.getParameterValues(parameterName)) {
                parameters.add(parameterName, parameterValue);
            }
        }
        return parameters;
    }

    public static HttpHeaders extractHttpHeaders(GrizzlyRequest request) {
        HttpHeadersImpl headers = new HttpHeadersImpl();
        MultivaluedMapImpl<String, String> requestHeaders = GrizzlyUtils.extractRequestHeaders(request);
        headers.setRequestHeaders(requestHeaders);
        List<MediaType> acceptableMediaTypes = GrizzlyUtils.extractAccepts(requestHeaders);
        headers.setAcceptableMediaTypes(acceptableMediaTypes);
        headers.setLanguage(requestHeaders.getFirst("Content-Language"));
        String contentType = request.getContentType();
        if (contentType != null) {
            headers.setMediaType(MediaType.valueOf((String)contentType));
        }
        Map<String, javax.ws.rs.core.Cookie> cookies = GrizzlyUtils.extractCookies(request);
        headers.setCookies(cookies);
        return headers;
    }

    static Map<String, javax.ws.rs.core.Cookie> extractCookies(GrizzlyRequest request) {
        HashMap<String, javax.ws.rs.core.Cookie> cookies = new HashMap<String, javax.ws.rs.core.Cookie>();
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                cookies.put(cookie.getName(), new javax.ws.rs.core.Cookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion()));
            }
        }
        return cookies;
    }

    public static List<MediaType> extractAccepts(MultivaluedMapImpl<String, String> requestHeaders) {
        ArrayList<MediaType> acceptableMediaTypes = new ArrayList<MediaType>();
        List accepts = (List)requestHeaders.get("Accept");
        if (accepts == null) {
            return acceptableMediaTypes;
        }
        for (String accept : accepts) {
            acceptableMediaTypes.addAll(MediaTypeHelper.parseHeader(accept));
        }
        return acceptableMediaTypes;
    }

    public static MultivaluedMapImpl<String, String> extractRequestHeaders(GrizzlyRequest request) {
        Headers<String> requestHeaders = new Headers<String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                requestHeaders.add(headerName, headerValue);
            }
        }
        return requestHeaders;
    }
}

