/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy.plugins.server.grizzly;

import com.sun.grizzly.http.servlet.CookieWrapper;
import com.sun.grizzly.http.servlet.HttpServletRequestImpl;
import com.sun.grizzly.http.servlet.HttpServletResponseImpl;
import com.sun.grizzly.http.servlet.ServletConfigImpl;
import com.sun.grizzly.http.servlet.ServletContextImpl;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.http.Cookie;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.logging.Level;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class SingletonServletAdapter
extends GrizzlyAdapter {
    private Servlet servletInstance = null;
    private ServletConfigImpl servletConfig;
    private String contextPath = "/";
    private HashMap<String, String> parameters = new HashMap();

    public SingletonServletAdapter() {
    }

    public SingletonServletAdapter(String publicDirectory) {
        super(publicDirectory);
        this.contextPath = publicDirectory;
    }

    public void init() throws ServletException {
        ServletContextWrapper servletCtx = new ServletContextWrapper();
        this.servletConfig = new ServletConfigImpl((ServletContextImpl)servletCtx);
        this.servletInstance.init((ServletConfig)this.servletConfig);
    }

    public void service(GrizzlyRequest request, GrizzlyResponse response) {
        try {
            HttpRequestWrapper httpRequest = new HttpRequestWrapper(request);
            HttpResponseWrapper httpResponse = new HttpResponseWrapper(response);
            httpResponse.addHeader("server", "grizzly/1.7");
            this.servletInstance.service((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        catch (Throwable ex) {
            this.logger.log(Level.SEVERE, "service exception:", ex);
        }
    }

    public void afterService(GrizzlyRequest request, GrizzlyResponse response) throws Exception {
    }

    public void addInitParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public Servlet getServletInstance() {
        return this.servletInstance;
    }

    public void setServletInstance(Servlet servletInstance) {
        this.servletInstance = servletInstance;
    }

    public class HttpResponseWrapper
    extends HttpServletResponseImpl {
        public HttpResponseWrapper(GrizzlyResponse response) throws IOException {
            super(response);
        }

        public void sendError(int sc) throws IOException {
            this.sendError(sc, null);
        }

        public void sendError(int sc, String msg) throws IOException {
            if (this.isCommitted()) {
                throw new IllegalStateException();
            }
            this.response.setAppCommitted(true);
            if (this.response.isCommitted()) {
                throw new IllegalStateException("response is already committed");
            }
            this.response.setError();
            this.response.getResponse().setStatus(sc);
            this.response.getResponse().setMessage(msg);
            this.response.resetBuffer();
        }
    }

    private class HttpRequestWrapper
    extends HttpServletRequestImpl {
        private HttpRequestWrapper(GrizzlyRequest grizzlyRequest) throws IOException {
            super(grizzlyRequest);
        }

        public javax.servlet.http.Cookie[] getCookies() {
            Cookie[] internalCookies = this.request.getCookies();
            if (internalCookies == null) {
                return null;
            }
            javax.servlet.http.Cookie[] cookies = new javax.servlet.http.Cookie[internalCookies.length];
            for (int i = 0; i < internalCookies.length; ++i) {
                Cookie cook = internalCookies[i];
                if (cook instanceof CookieWrapper) {
                    cookies[i] = ((CookieWrapper)internalCookies[i]).getWrappedCookie();
                    continue;
                }
                cookies[i] = new javax.servlet.http.Cookie(cook.getName(), cook.getValue());
                cookies[i].setComment(cook.getComment());
                if (cook.getDomain() != null) {
                    cookies[i].setDomain(cook.getDomain());
                }
                cookies[i].setMaxAge(cook.getMaxAge());
                cookies[i].setPath(cook.getPath());
                cookies[i].setSecure(cook.getSecure());
                cookies[i].setVersion(cook.getVersion());
            }
            return cookies;
        }

        public String getContextPath() {
            return SingletonServletAdapter.this.contextPath;
        }

        public String getPathInfo() {
            if (this.request == null) {
                throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
            }
            String requestURIString = this.request.getRequestURI();
            URI requestURI = URI.create(requestURIString);
            String path = requestURI.getPath();
            String contextPath = this.getContextPath();
            if (contextPath.equals("/")) {
                return path;
            }
            if (path.startsWith(contextPath)) {
                path = path.substring(contextPath.length());
                return path;
            }
            throw new IllegalStateException("Request path not in servlet context. path: " + path + " contextPath: " + contextPath);
        }

        public StringBuffer getRequestURL() {
            StringBuffer url = new StringBuffer();
            String scheme = "http";
            int port = this.getServerPort();
            if (port < 0) {
                port = 80;
            }
            url.append(scheme);
            url.append("://");
            url.append(this.getServerName());
            if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
                url.append(':');
                url.append(port);
            }
            url.append(this.getRequestURI());
            return url;
        }
    }

    private class ServletContextWrapper
    extends ServletContextImpl {
        private ServletContextWrapper() {
            this.setInitParameter(SingletonServletAdapter.this.parameters);
        }
    }
}

