/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy.plugins.server.tjws;

import javax.ws.rs.core.ApplicationConfig;
import org.resteasy.Dispatcher;
import org.resteasy.plugins.providers.RegisterBuiltin;
import org.resteasy.plugins.server.embedded.EmbeddedJaxrsServer;
import org.resteasy.plugins.server.embedded.SecurityDomain;
import org.resteasy.plugins.server.tjws.TJWSServletDispatcher;
import org.resteasy.plugins.server.tjws.TJWSServletServer;
import org.resteasy.spi.Registry;
import org.resteasy.spi.ResteasyProviderFactory;

public class TJWSEmbeddedJaxrsServer
extends TJWSServletServer
implements EmbeddedJaxrsServer {
    protected ResteasyProviderFactory factory = new ResteasyProviderFactory();
    protected Registry registry;
    protected Dispatcher dispatcher;
    protected TJWSServletDispatcher servlet = new TJWSServletDispatcher();
    protected String rootResourcePath = "";

    public void setRootResourcePath(String rootResourcePath) {
        this.rootResourcePath = rootResourcePath;
    }

    public TJWSEmbeddedJaxrsServer() {
        ResteasyProviderFactory.setInstance(this.factory);
        this.dispatcher = new Dispatcher(this.factory);
        this.registry = this.dispatcher.getRegistry();
        ResteasyProviderFactory.setInstance(this.factory);
        RegisterBuiltin.register(this.factory);
    }

    public void start() {
        this.server.setAttribute(ResteasyProviderFactory.class.getName(), (Object)this.factory);
        this.server.setAttribute(Registry.class.getName(), (Object)this.registry);
        this.server.setAttribute(Dispatcher.class.getName(), (Object)this.dispatcher);
        this.addServlet(this.rootResourcePath, this.servlet);
        this.servlet.setContextPath(this.rootResourcePath);
        super.start();
    }

    public ResteasyProviderFactory getFactory() {
        return this.factory;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setSecurityDomain(SecurityDomain sc) {
        this.servlet.setSecurityDomain(sc);
    }

    public void addApplicationConfig(ApplicationConfig config) {
        this.dispatcher.setLanguageMappings(config.getLanguageMappings());
        this.dispatcher.setMediaTypeMappings(config.getMediaTypeMappings());
        if (config.getResourceClasses() != null) {
            for (Class clazz : config.getResourceClasses()) {
                this.registry.addPerRequestResource(clazz);
            }
        }
        if (config.getProviderClasses() != null) {
            for (Class provider : config.getProviderClasses()) {
                this.factory.registerProvider(provider);
            }
        }
    }
}

