/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy.specimpl;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import org.resteasy.specimpl.MultivaluedMapImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathSegmentImpl
implements PathSegment {
    private String path;
    private String original;
    private MultivaluedMap<String, String> matrixParameters = new MultivaluedMapImpl<String, String>();

    public PathSegmentImpl(String path) {
        this.original = path;
        this.path = path;
        int semicolon = path.indexOf(59);
        if (semicolon >= 0) {
            String[] params;
            this.path = semicolon > 0 ? path.substring(0, semicolon) : "";
            String matrixParams = path.substring(semicolon + 1);
            for (String param : params = matrixParams.split(";")) {
                String[] namevalue = param.split("=");
                if (namevalue == null || namevalue.length <= 0) continue;
                String name = namevalue[0];
                String value = "";
                if (namevalue.length > 1) {
                    value = namevalue[1];
                }
                this.matrixParameters.add((Object)name, (Object)value);
            }
        }
    }

    public String getOriginal() {
        return this.original;
    }

    public PathSegmentImpl(String path, MultivaluedMap<String, String> matrixParameters) {
        this.path = path;
        this.matrixParameters = matrixParameters;
    }

    public String getPath() {
        return this.path;
    }

    public MultivaluedMap<String, String> getMatrixParameters() {
        return this.matrixParameters;
    }

    public static List<PathSegment> parseSegments(String path) {
        String[] paths;
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        for (String p : paths = path.split("/")) {
            pathSegments.add(new PathSegmentImpl(p));
        }
        return pathSegments;
    }
}

