/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertCli;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.security.PermissionCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bindings.ScriptEngineFactory;
import org.rhq.bindings.StandardBindings;
import org.rhq.bindings.StandardScriptPermissions;
import org.rhq.bindings.client.RhqFacade;
import org.rhq.bindings.util.PackageFinder;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.criteria.RepoCriteria;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.client.LocalClient;
import org.rhq.enterprise.server.auth.SessionManager;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSenderValidationResults;
import org.rhq.enterprise.server.plugins.alertCli.CliComponent;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.scripting.ScriptEngineInitializer;
import org.rhq.scripting.ScriptSourceProvider;
import org.rhq.scripting.ScriptSourceProviderFactory;

public class CliSender
extends AlertSender<CliComponent> {
    private static final int MAX_RESULT_SIZE = 4000;
    public static final String PROP_PACKAGE_ID = "packageId";
    public static final String PROP_REPO_ID = "repoId";
    public static final String PROP_USER_ID = "userId";
    public static final String PROP_USER_NAME = "userName";
    public static final String PROP_USER_PASSWORD = "userPassword";
    private static final Log LOG = LogFactory.getLog(CliSender.class);
    private static final String SUMMARY_TEMPLATE = "Ran script $packageName in version $packageVersion from repo $repoName as user $userName.";
    private static final String PREVIEW_TEMPLATE = "Run script $packageName from repo $repoName as user $userName.";
    private static final String VALIDATION_ERROR_MESSAGE = "The provided user failed to authenticate.";
    private static final int MAX_SCRIPT_ENGINES = 10;
    private static Map<String, Queue<ScriptEngine>> SCRIPT_ENGINES = new HashMap<String, Queue<ScriptEngine>>();
    private static int ENGINES_IN_USE = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SenderResult send(Alert alert) {
        SenderResult senderResult;
        String language;
        ScriptEngine engine;
        BufferedReader reader;
        block30: {
            SenderResult result = new SenderResult();
            reader = null;
            engine = null;
            Subject subjectWithSession = null;
            SessionManager sessionManager = SessionManager.getInstance();
            language = null;
            try {
                Config config = this.getConfig();
                subjectWithSession = config.subject = sessionManager.put(config.subject, (long)(((CliComponent)this.pluginComponent).getScriptTimeout() * 1000));
                result.setSummary(CliSender.createSummary(config, SUMMARY_TEMPLATE));
                ByteArrayOutputStream scriptOutputStream = new ByteArrayOutputStream();
                PrintWriter scriptOut = new PrintWriter(scriptOutputStream);
                BitsAndFileExtension packageData = CliSender.getPackageBits(config.packageId, config.repoId);
                InputStream packageBits = packageData.packageBits;
                String scriptFileExtension = packageData.scriptFileExtension;
                language = ScriptEngineFactory.getLanguageByScriptFileExtension((String)scriptFileExtension);
                if (language == null) {
                    ArrayList<String> supportedExtensions = new ArrayList<String>();
                    for (String lang : ScriptEngineFactory.getSupportedLanguages()) {
                        supportedExtensions.add(ScriptEngineFactory.getFileExtensionForLanguage((String)lang));
                    }
                    throw new IllegalArgumentException("Could not determine the script engine to use based on the script file extension '" + scriptFileExtension + "'. Only the following extensions are currently supported: " + supportedExtensions);
                }
                engine = CliSender.getScriptEngine(alert, scriptOut, config, language);
                final BufferedReader rdr = reader = new BufferedReader(new InputStreamReader(packageBits));
                final ExceptionHolder exceptionHolder = new ExceptionHolder();
                final ScriptEngine e = engine;
                Thread scriptRunner = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            e.eval(rdr);
                        }
                        catch (ScriptException e2) {
                            exceptionHolder.scriptException = e2;
                        }
                        catch (Throwable e3) {
                            exceptionHolder.throwable = e3;
                        }
                    }
                }, "Script Runner for alert " + alert);
                scriptRunner.setDaemon(true);
                scriptRunner.start();
                if (((CliComponent)this.pluginComponent).getScriptTimeout() <= 0) {
                    scriptRunner.join();
                } else {
                    scriptRunner.join(((CliComponent)this.pluginComponent).getScriptTimeout() * 1000);
                }
                scriptRunner.interrupt();
                if (exceptionHolder.scriptException != null) {
                    LOG.info((Object)("The script execution for CLI notification of alert [" + alert + "] failed."), (Throwable)exceptionHolder.scriptException);
                    ScriptEngineInitializer initializer = ScriptEngineFactory.getInitializer((String)language);
                    String message = initializer.extractUserFriendlyErrorMessage(exceptionHolder.scriptException);
                    int col = exceptionHolder.scriptException.getColumnNumber();
                    int line = exceptionHolder.scriptException.getLineNumber();
                    String scriptName = CliSender.createSummary(config, "script $packageName ($packageVersion) in repo $repoName");
                    throw new ScriptException(message, scriptName, line, col);
                }
                if (exceptionHolder.throwable != null) {
                    LOG.info((Object)("The script execution for CLI notification of alert [" + alert + "] failed."), exceptionHolder.throwable);
                    throw exceptionHolder.throwable;
                }
                scriptOut.flush();
                String scriptOutput = scriptOutputStream.toString(Charset.defaultCharset().name());
                if (scriptOutput.length() == 0) {
                    scriptOutput = "Script generated no output.";
                }
                if (scriptOutput.length() > CliSender.remainingResultSize(result)) {
                    scriptOutput = scriptOutput.substring(0, CliSender.remainingResultSize(result));
                }
                result.addSuccessMessage(scriptOutput);
                senderResult = result;
                if (subjectWithSession == null) break block30;
            }
            catch (IllegalArgumentException e) {
                SenderResult senderResult2 = SenderResult.getSimpleFailure((String)e.getMessage());
                return senderResult2;
            }
            catch (Throwable e2) {
                SenderResult senderResult3;
                block31: {
                    result.addFailureMessage(ThrowableUtil.getAllMessages((Throwable)e2, (boolean)true, (int)CliSender.remainingResultSize(result)));
                    senderResult3 = result;
                    if (subjectWithSession == null) break block31;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    sessionManager.invalidate(subjectWithSession.getSessionId().intValue());
                }
                if (engine != null) {
                    CliSender.returnEngine(engine, language);
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e22) {
                        LOG.error((Object)"Failed to close the script reader.", (Throwable)e22);
                    }
                }
                return senderResult3;
            }
            finally {
                if (subjectWithSession != null) {
                    sessionManager.invalidate(subjectWithSession.getSessionId().intValue());
                }
                if (engine != null) {
                    CliSender.returnEngine(engine, language);
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Failed to close the script reader.", (Throwable)e);
                    }
                }
            }
            sessionManager.invalidate(subjectWithSession.getSessionId().intValue());
        }
        if (engine != null) {
            CliSender.returnEngine(engine, language);
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to close the script reader.", (Throwable)e);
            }
        }
        return senderResult;
    }

    public String previewConfiguration() {
        try {
            Config c = this.getConfig();
            return CliSender.createSummary(c, PREVIEW_TEMPLATE);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to get the configuration preview.", (Throwable)e);
            return "Failed to get configuration preview: " + e.getMessage();
        }
    }

    public AlertSenderValidationResults validateAndFinalizeConfiguration(Subject subject) {
        Integer userId;
        AlertSenderValidationResults results = new AlertSenderValidationResults(this.alertParameters, this.extraParameters);
        String userIdString = this.alertParameters.getSimpleValue(PROP_USER_ID, null);
        String userName = this.alertParameters.getSimpleValue(PROP_USER_NAME, null);
        String userPassword = this.alertParameters.getSimpleValue(PROP_USER_PASSWORD, null);
        Integer n = userId = userIdString == null ? null : Integer.valueOf(userIdString);
        if (userId == null || userId.intValue() != subject.getId()) {
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            Subject authSubject = subjectManager.checkAuthentication(userName, userPassword);
            if (authSubject == null) {
                PropertySimple userNameProp = new PropertySimple(PROP_USER_NAME, (Object)userName);
                userNameProp.setErrorMessage(VALIDATION_ERROR_MESSAGE);
                this.alertParameters.put((Property)userNameProp);
                this.alertParameters.put((Property)new PropertySimple(PROP_USER_ID, null));
            } else {
                this.alertParameters.put((Property)new PropertySimple(PROP_USER_ID, (Object)authSubject.getId()));
            }
        } else {
            this.alertParameters.put((Property)new PropertySimple(PROP_USER_NAME, (Object)subject.getName()));
        }
        this.alertParameters.put((Property)new PropertySimple(PROP_USER_PASSWORD, null));
        return results;
    }

    private static ScriptEngine getScriptEngine(Alert alert, PrintWriter output, Config config, String language) throws ScriptException, IOException, InterruptedException {
        Subject user = config.subject;
        LocalClient client = new LocalClient(user);
        StandardBindings bindings = new StandardBindings(output, (RhqFacade)client);
        bindings.put((Object)"alert", (Object)alert);
        ScriptEngine engine = CliSender.takeEngine(bindings, language);
        engine.getContext().setWriter(output);
        engine.getContext().setErrorWriter(output);
        return engine;
    }

    private static BitsAndFileExtension getPackageBits(int packageId, int repoId) throws IOException {
        int dotIdx;
        final ContentSourceManagerLocal csm = LookupUtil.getContentSourceManager();
        RepoManagerLocal rm = LookupUtil.getRepoManagerLocal();
        final PackageVersion versionToUse = rm.getLatestPackageVersion(LookupUtil.getSubjectManager().getOverlord(), packageId, repoId);
        if (versionToUse == null) {
            throw new IllegalArgumentException("The package with id " + packageId + " either doesn't exist at all or doesn't have any version. Can't execute a CLI script without a script to run.");
        }
        PipedInputStream bits = new PipedInputStream();
        final PipedOutputStream out = new PipedOutputStream(bits);
        Thread reader = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    csm.outputPackageVersionBits(versionToUse, (OutputStream)out);
                }
                catch (RuntimeException e) {
                    LOG.warn((Object)("The thread for reading the bits of package version [" + versionToUse + "] failed with exception."), (Throwable)e);
                    throw e;
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Failed to close the piped output stream receiving the package bits of package version " + versionToUse + ". This should never happen."), (Throwable)e);
                    }
                }
            }
        });
        reader.setName("CLI Alert download thread for package version " + versionToUse);
        reader.setDaemon(true);
        reader.start();
        BitsAndFileExtension ret = new BitsAndFileExtension();
        ret.packageBits = bits;
        String fileName = versionToUse.getFileName();
        String extension = "";
        if (fileName != null && (dotIdx = fileName.lastIndexOf(46)) >= 0) {
            extension = fileName.substring(dotIdx + 1);
        }
        ret.scriptFileExtension = extension;
        return ret;
    }

    private static String createSummary(Config config, String template) {
        try {
            String ret = template;
            ret = ret.replace("$userName", config.subject.getName());
            Subject overlord = LookupUtil.getSubjectManager().getOverlord();
            RepoManagerLocal rm = LookupUtil.getRepoManagerLocal();
            PackageVersion versionToUse = rm.getLatestPackageVersion(overlord, config.packageId, config.repoId);
            if (versionToUse != null) {
                ret = ret.replace("$packageName", versionToUse.getDisplayName());
                ret = ret.replace("$packageVersion", versionToUse.getDisplayVersion() == null ? versionToUse.getVersion() : versionToUse.getDisplayVersion());
            } else {
                ret = ret.replace("$packageName", "unknown script with package id " + config.packageId);
                ret = ret.replace("$packageVersion", "no version");
            }
            RepoCriteria criteria = new RepoCriteria();
            criteria.addFilterId(Integer.valueOf(config.repoId));
            PageList repos = rm.findReposByCriteria(overlord, criteria);
            String repoName = repos.size() > 0 ? ((Repo)repos.get(0)).getName() : "unknown repo with id " + config.repoId;
            ret = ret.replace("$repoName", repoName);
            return ret;
        }
        catch (Exception e) {
            LOG.info((Object)"Failed to create alert sender summary.", (Throwable)e);
            return "Failed to create summary: " + e.getMessage();
        }
    }

    private Config getConfig() throws IllegalArgumentException {
        Config ret = new Config();
        int subjectId = this.getIntFromConfiguration(PROP_USER_ID, "User id not specified.", "Failed to read subject id property: ");
        int packageId = this.getIntFromConfiguration(PROP_PACKAGE_ID, "Package id of the script not specified.", "Failed to read the package id property: ");
        int repoId = this.getIntFromConfiguration(PROP_REPO_ID, "Repo to download the script package from not specified.", "Failed to read the repo id property: ");
        Subject subject = LookupUtil.getSubjectManager().getSubjectById(subjectId);
        if (subject == null) {
            throw new IllegalArgumentException("User with id " + subjectId + " doesn't exist anymore.");
        }
        ret.subject = subject;
        ret.packageId = packageId;
        ret.repoId = repoId;
        return ret;
    }

    private int getIntFromConfiguration(String propName, String errorMessage, String convertErrorMessage) throws IllegalArgumentException {
        PropertySimple prop = this.alertParameters.getSimple(propName);
        if (prop == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        try {
            return prop.getIntegerValue();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(convertErrorMessage + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScriptEngine takeEngine(StandardBindings bindings, String language) throws InterruptedException, ScriptException, IOException {
        Map<String, Queue<ScriptEngine>> map = SCRIPT_ENGINES;
        synchronized (map) {
            ScriptEngine engine;
            Queue<ScriptEngine> q;
            if (ENGINES_IN_USE >= 10) {
                SCRIPT_ENGINES.wait();
            }
            if ((q = SCRIPT_ENGINES.get(language)) == null) {
                q = new ArrayDeque<ScriptEngine>();
                SCRIPT_ENGINES.put(language, q);
            }
            if ((engine = q.poll()) == null) {
                engine = ScriptEngineFactory.getSecuredScriptEngine((String)language, (PackageFinder)new PackageFinder(Collections.emptyList()), (StandardBindings)bindings, (PermissionCollection)new StandardScriptPermissions());
            }
            ScriptSourceProvider[] providers = ScriptSourceProviderFactory.get(null);
            ScriptEngineFactory.injectStandardBindings((ScriptEngine)engine, (StandardBindings)bindings, (boolean)true, (ScriptSourceProvider[])providers);
            ++ENGINES_IN_USE;
            return engine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void returnEngine(ScriptEngine engine, String language) {
        Map<String, Queue<ScriptEngine>> map = SCRIPT_ENGINES;
        synchronized (map) {
            Queue<ScriptEngine> q = SCRIPT_ENGINES.get(language);
            if (q == null) {
                q = new ArrayDeque<ScriptEngine>();
                SCRIPT_ENGINES.put(language, q);
            }
            q.offer(engine);
            --ENGINES_IN_USE;
            SCRIPT_ENGINES.notify();
        }
    }

    private static int remainingResultSize(SenderResult r) {
        int ret = 4000 - r.getSummary().length() - 10;
        for (String m : r.getSuccessMessages()) {
            ret -= m.length() + 10;
        }
        for (String m : r.getFailureMessages()) {
            ret -= m.length() + 10;
        }
        return ret;
    }

    private static class BitsAndFileExtension {
        InputStream packageBits;
        String scriptFileExtension;

        private BitsAndFileExtension() {
        }
    }

    private static class ExceptionHolder {
        public ScriptException scriptException;
        public Throwable throwable;

        private ExceptionHolder() {
        }
    }

    private static class Config {
        Subject subject;
        int packageId;
        int repoId;

        private Config() {
        }
    }
}

