/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertIrc;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibble.pircbot.PircBot;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginContext;

public class IrcAlertComponent
implements ServerPluginComponent {
    private static final String DEFAULT_IRC_PORT = "6667";
    private final Log log = LogFactory.getLog(IrcAlertComponent.class);
    private RhqAlertBot ircBot;
    private String nick;
    private String server;
    private int port;
    private String[] channels;
    private String cannedResponse;

    public void initialize(ServerPluginContext context) throws Exception {
        Configuration preferences = context.getPluginConfiguration();
        this.nick = preferences.getSimpleValue("nick", null);
        this.server = preferences.getSimpleValue("server", null);
        this.port = Integer.parseInt(preferences.getSimpleValue("port", DEFAULT_IRC_PORT));
        this.channels = this.parseChannels(preferences.getSimpleValue("initialChannels", null));
        this.cannedResponse = preferences.getSimpleValue("cannedResponse", null);
    }

    private String[] parseChannels(String channelList) {
        if (channelList != null && channelList.length() > 0) {
            return channelList.split(",");
        }
        return new String[0];
    }

    public void start() {
        this.ircBot = new RhqAlertBot(this.nick, this.cannedResponse);
        if (this.server != null && this.server.length() > 0) {
            try {
                this.ircBot.connect(this.server, this.port);
                this.log.info((Object)("Connected to server " + this.server + ":" + this.port));
            }
            catch (Exception e) {
                this.log.error((Object)("Error joining IRC: " + e.getMessage()));
                return;
            }
            for (String channel : this.channels) {
                this.ircBot.joinChannel(channel);
            }
        } else {
            this.log.info((Object)"IRC Server not specified -- skipping connection.");
        }
    }

    public void stop() {
        this.ircBot.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.ircBot.dispose();
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to dispose of the IRC bot object: " + e.getMessage()));
        }
        finally {
            this.ircBot = null;
        }
    }

    public void sendIrcMessage(String channel, String message) {
        if (this.ircBot != null && this.ircBot.isConnected()) {
            for (String sendChannel : this.getChannelsToSend(channel)) {
                this.ircBot.sendMessage(sendChannel, message);
            }
        } else {
            throw new IllegalStateException("IRC bot has not been initialized");
        }
    }

    private String[] getChannelsToSend(String channel) {
        if (channel != null && channel.length() > 0) {
            if (!this.isInChannel(channel)) {
                this.ircBot.joinChannel(channel);
            }
            return new String[]{channel};
        }
        return this.ircBot.getChannels();
    }

    private boolean isInChannel(String channel) {
        return Arrays.asList(this.ircBot.getChannels()).contains(channel);
    }

    private class RhqAlertBot
    extends PircBot {
        private String response;

        private RhqAlertBot(String name, String defaultResponse) {
            this.setName(name);
            this.response = defaultResponse;
        }

        public void onMessage(String channel, String sender, String login, String hostname, String message) {
            if (this.response != null && message.startsWith(IrcAlertComponent.this.nick)) {
                if (channel != null && channel.length() > 0) {
                    this.sendMessage(channel, sender + ":  " + this.response);
                } else {
                    this.sendMessage(sender, this.response);
                }
            }
        }
    }
}

