/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertlog4j;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class Log4JSender
extends AlertSender {
    private final Log log = LogFactory.getLog(Log4JSender.class);

    public SenderResult send(Alert alert) {
        String category = this.alertParameters.getSimpleValue("log4JCategory", ((Object)((Object)this)).getClass().getName());
        Logger logger = Logger.getLogger((String)category);
        AlertManagerLocal alertManager = LookupUtil.getAlertManager();
        ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        List lineage = resourceManager.getResourceLineage(alert.getAlertDefinition().getResource().getId());
        String platformName = ((Resource)lineage.get(0)).getName();
        String conditions = alertManager.prettyPrintAlertConditions(alert, false).replace('\n', ' ');
        String alertURL = alertManager.prettyPrintAlertURL(alert);
        StringBuilder message = new StringBuilder();
        message.append("ALERT,");
        message.append(alert.getAlertDefinition().getPriority().getName());
        message.append(',');
        message.append(alert.getAlertDefinition().getName());
        message.append(',');
        message.append(alert.getAlertDefinition().getDescription());
        message.append(',');
        message.append(alert.getAlertDefinition().getResource().getName()).append(',');
        message.append(platformName).append(',');
        message.append(conditions).append(',');
        message.append(alertURL);
        switch (alert.getAlertDefinition().getPriority()) {
            case HIGH: {
                logger.error((Object)message);
                break;
            }
            case MEDIUM: {
                logger.warn((Object)message);
                break;
            }
            case LOW: {
                logger.info((Object)message);
                break;
            }
        }
        return SenderResult.getSimpleSuccess((String)("Alert Sent to Log4J Category " + category));
    }
}

