/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertRoles;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugin.pc.alert.CustomAlertSenderBackingBean;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolesBackingBean
extends CustomAlertSenderBackingBean {
    private Map<String, String> available;
    private List<String> currentRoles;
    private static final String ROLE_ID = "roleId";

    public void loadView() {
        PageList allRoles = LookupUtil.getRoleManager().findRoles(new PageControl());
        this.available = new HashMap<String, String>();
        for (Role role : allRoles) {
            String roleId = String.valueOf(role.getId());
            this.available.put(role.getName(), roleId);
        }
        String subjectString = this.alertParameters.getSimpleValue(ROLE_ID, "");
        this.currentRoles = AlertSender.unfence((String)subjectString, String.class);
    }

    public void saveView() {
        String roleIds = AlertSender.fence(this.currentRoles);
        PropertySimple p = this.alertParameters.getSimple(ROLE_ID);
        if (p == null) {
            p = new PropertySimple(ROLE_ID, (Object)roleIds);
            this.alertParameters.put((Property)p);
        } else {
            p.setStringValue(roleIds);
        }
        this.alertParameters = this.persistConfiguration(this.alertParameters);
    }

    public List<String> getCurrentRoles() {
        return this.currentRoles;
    }

    public void setCurrentRoles(List<String> currentRoles) {
        this.currentRoles = currentRoles;
    }

    public Map<String, String> getAvailableRolesMap() {
        return this.available;
    }
}

