/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertSnmp;

import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.ResultState;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugins.alertSnmp.SnmpTrapSender;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class SnmpSender
extends AlertSender {
    private final Log log = LogFactory.getLog(SnmpSender.class);

    public SenderResult send(Alert alert) {
        SenderResult res;
        String result;
        Date bootTime = null;
        String oid = this.alertParameters.getSimpleValue("OID", null);
        if (oid == null) {
            return new SenderResult(ResultState.FAILURE, "no OID given");
        }
        String host = this.alertParameters.getSimpleValue("host", null);
        if (host == null) {
            return new SenderResult(ResultState.FAILURE, "no host given");
        }
        String portS = this.alertParameters.getSimpleValue("port", "162");
        Integer port = Integer.valueOf(portS);
        AlertManagerLocal alertManager = LookupUtil.getAlertManager();
        ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        SnmpTrapSender snmpTrapSender = new SnmpTrapSender(this.preferences);
        this.log.debug((Object)("Sending SNMP trap with OID " + oid + " to SNMP engine " + host + ":" + port + "..."));
        List lineage = resourceManager.getResourceLineage(alert.getAlertDefinition().getResource().getId());
        String platformName = ((Resource)lineage.get(0)).getName();
        String conditions = alertManager.prettyPrintAlertConditions(alert, false);
        String alertUrl = alertManager.prettyPrintAlertURL(alert);
        try {
            bootTime = new Date();
            result = snmpTrapSender.sendSnmpTrap(alert, this.alertParameters, platformName, conditions, bootTime, alertUrl);
            res = new SenderResult(ResultState.SUCCESS, result);
        }
        catch (Throwable t) {
            result = "failed - cause: " + t;
            res = new SenderResult(ResultState.FAILURE, result);
        }
        this.log.debug((Object)("Result of sending SNMP trap: " + result));
        return res;
    }
}

