/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertSnmp;

import org.rhq.core.domain.configuration.Configuration;

public class SnmpInfo {
    public final String host;
    public final String port;
    public final String oid;
    public final String error;

    private SnmpInfo(String host, String port, String oid) {
        this.host = host;
        this.port = port;
        this.oid = oid;
        String error = null;
        if (oid == null) {
            error = "Missing: OID";
        }
        if (host == null) {
            error = error == null ? "Missing: host" : error + ", host";
        }
        this.error = error;
    }

    public static SnmpInfo load(Configuration configuration) {
        String host = configuration.getSimpleValue("host", null);
        String port = configuration.getSimpleValue("port", "162");
        String oid = configuration.getSimpleValue("OID", null);
        return new SnmpInfo(host, port, oid);
    }

    public String toString() {
        String hostString = this.host == null ? "UnknownHost" : this.host;
        String oidString = this.oid == null ? "UnknownOID" : this.oid;
        return hostString + ":" + this.port + " (" + oidString + ")";
    }
}

