/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertSnmp;

import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.ResultState;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugins.alertSnmp.SnmpInfo;
import org.rhq.enterprise.server.plugins.alertSnmp.SnmpTrapSender;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class SnmpSender
extends AlertSender {
    private final Log log = LogFactory.getLog(SnmpSender.class);

    public SenderResult send(Alert alert) {
        SenderResult res;
        String result;
        SnmpInfo info = SnmpInfo.load(this.alertParameters);
        if (info.error != null) {
            return new SenderResult(ResultState.FAILURE, info.error);
        }
        this.log.debug((Object)("Sending SNMP trap to: " + info));
        AlertManagerLocal alertManager = LookupUtil.getAlertManager();
        ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        SnmpTrapSender snmpTrapSender = new SnmpTrapSender(this.preferences);
        List lineage = resourceManager.getResourceLineage(alert.getAlertDefinition().getResource().getId());
        String platformName = ((Resource)lineage.get(0)).getName();
        String conditions = alertManager.prettyPrintAlertConditions(alert, false);
        String alertUrl = alertManager.prettyPrintAlertURL(alert);
        try {
            Date bootTime = new Date();
            result = snmpTrapSender.sendSnmpTrap(alert, this.alertParameters, platformName, conditions, bootTime, alertUrl);
            res = new SenderResult(ResultState.SUCCESS, result);
        }
        catch (Throwable t) {
            result = "failed - cause: " + t;
            res = new SenderResult(ResultState.FAILURE, result);
        }
        this.log.debug((Object)("Result of sending SNMP trap: " + result));
        return res;
    }

    public String previewConfiguration() {
        SnmpInfo info = SnmpInfo.load(this.alertParameters);
        return info.toString();
    }
}

