/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertSnmp;

import org.rhq.core.domain.configuration.Configuration;

@Deprecated
public class SnmpInfo {
    static final String PARAM_HOST = "host";
    static final String PARAM_PORT = "port";
    static final String PARAM_VARIABLE_BINDING_PREFIX = "oid";
    static final String PARAM_TRAP_OID = "trapOid";
    static final String DEFAULT_PORT = "162";
    private static final String DEFAULT_RHQ_BINDING = "1.3.6.1.4.1.18016.2.1";
    public final String host;
    public final String port;
    public final String oid;
    public final String trapOid;
    public final String error;

    private SnmpInfo(String host, String port, String oid, String trapOid) {
        this.host = host;
        this.port = port;
        this.oid = oid;
        this.trapOid = trapOid;
        String error = null;
        if (oid == null) {
            error = "Missing: OID";
        }
        if (host == null) {
            error = error == null ? "Missing: host" : error + ", host";
        }
        this.error = error;
    }

    public static SnmpInfo load(Configuration configuration) {
        String host = configuration.getSimpleValue(PARAM_HOST, null);
        String port = configuration.getSimpleValue(PARAM_PORT, DEFAULT_PORT);
        String oid = configuration.getSimpleValue(PARAM_VARIABLE_BINDING_PREFIX, null);
        String trapOid = configuration.getSimpleValue(PARAM_TRAP_OID, null);
        return new SnmpInfo(host, port, oid, trapOid);
    }

    protected static SnmpInfo load(Configuration configuration, Configuration preferences) {
        String port;
        String host = configuration.getSimpleValue(PARAM_HOST, null);
        if (host == null || host.isEmpty()) {
            host = preferences.getSimpleValue("defaultTargetHost", null);
        }
        if ((port = configuration.getSimpleValue(PARAM_PORT, null)) == null || port.isEmpty()) {
            port = preferences.getSimpleValue("defaultPort", DEFAULT_PORT);
        }
        String oid = configuration.getSimpleValue(PARAM_VARIABLE_BINDING_PREFIX, DEFAULT_RHQ_BINDING);
        String trapOid = configuration.getSimpleValue(PARAM_TRAP_OID, null);
        return new SnmpInfo(host, port, oid, trapOid);
    }

    public String toString() {
        String hostString = this.host == null ? "UnknownHost" : this.host;
        String oidString = this.oid == null ? "Unknown Binding Prefix" : this.oid;
        String trapOidString = this.trapOid == null ? "DefaultTrapOID" : this.trapOid;
        return hostString + ":" + this.port + " (" + oidString + ") (" + trapOidString + ")";
    }
}

