/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.checkstyle.xml;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlIndentCheck
extends AbstractFileSetCheck {
    public static final int DEFAULT_INDENT_SIZE = 4;
    public static final String INDENT_SIZE_ATTRIBUTE = "indentSize";
    private String encoding;
    private int indentSize = 4;
    private SAXParserFactory saxParserFactory;

    public XmlIndentCheck() {
        this.setFileExtensions(new String[]{".xml"});
        this.saxParserFactory = SAXParserFactory.newInstance();
        this.saxParserFactory.setValidating(false);
    }

    public void beginProcessing(String aCharset) {
        this.encoding = aCharset;
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    protected void processFiltered(File aFile, List<String> aLines) {
        Reader in = null;
        try {
            in = new InputStreamReader((InputStream)new FileInputStream(aFile), this.encoding);
            SAXParser saxParser = this.saxParserFactory.newSAXParser();
            IndentHandler handler = new IndentHandler();
            saxParser.parse(new InputSource(in), (DefaultHandler)handler);
        }
        catch (SAXException e) {
            this.log(0, "SAXException: {0}", new Object[]{e.getMessage()});
        }
        catch (IOException e) {
            this.log(0, "IOException: {0}", new Object[]{e.getMessage()});
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void setIndentSize(int indentSize) {
        this.indentSize = indentSize;
    }

    private class IndentHandler
    extends DefaultHandler {
        private final StringBuilder charBuffer = new StringBuilder();
        private int charLineNumber;
        private Indent lastIndent = Indent.START;
        private Locator locator;
        private FastStack<ElementEntry> stack = FastStack.newInstance();

        private IndentHandler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.charBuffer.append(ch, start, length);
            this.charLineNumber = this.locator.getLineNumber();
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.flushCharacters();
            if (this.stack.isEmpty()) {
                throw new IllegalStateException("Stack must not be empty when closing the element " + qName + " around line " + this.locator.getLineNumber() + " and column " + this.locator.getColumnNumber());
            }
            ElementEntry startEntry = (ElementEntry)this.stack.pop();
            int indentDiff = this.lastIndent.size - startEntry.expectedIndent.size;
            int expectedIndent = startEntry.expectedIndent.size;
            if (this.lastIndent.lineNumber != startEntry.foundIndent.lineNumber && indentDiff != 0) {
                XmlIndentCheck.this.log(this.locator.getLineNumber(), this.locator.getColumnNumber(), "Expected indent {0} before end element {1}", new Object[]{expectedIndent, "</" + qName + ">"});
            }
        }

        private void flushCharacters() {
            int indentLength = 0;
            int len = this.charBuffer.length();
            block4: for (int i = len - 1; i >= 0; --i) {
                char ch = this.charBuffer.charAt(i);
                switch (ch) {
                    case '\n': 
                    case '\r': {
                        this.lastIndent = new Indent(this.charLineNumber, indentLength);
                        this.charBuffer.setLength(0);
                        return;
                    }
                    case '\t': 
                    case ' ': {
                        ++indentLength;
                        continue block4;
                    }
                    default: {
                        this.charBuffer.setLength(0);
                        return;
                    }
                }
            }
        }

        public void ignorableWhitespace(char[] chars, int start, int length) throws SAXException {
            this.characters(chars, start, length);
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.flushCharacters();
            ElementEntry currentEntry = new ElementEntry(qName, this.lastIndent);
            if (!this.stack.isEmpty()) {
                ElementEntry parentEntry = (ElementEntry)this.stack.peek();
                int indentDiff = currentEntry.foundIndent.size - parentEntry.expectedIndent.size;
                int expectedIndent = parentEntry.expectedIndent.size + XmlIndentCheck.this.indentSize;
                if ((indentDiff != 0 || currentEntry.foundIndent.lineNumber != parentEntry.foundIndent.lineNumber) && indentDiff != XmlIndentCheck.this.indentSize) {
                    XmlIndentCheck.this.log(this.locator.getLineNumber(), this.locator.getColumnNumber(), "Expected indent {0} before start element {1}", new Object[]{expectedIndent, "<" + currentEntry.elementName + ">"});
                    currentEntry = new ElementEntry(qName, this.lastIndent, new Indent(this.lastIndent.lineNumber, expectedIndent));
                }
            }
            this.stack.push((Object)currentEntry);
        }
    }

    private static class Indent {
        public static final Indent START = new Indent(1, 0);
        private final int size;
        private final int lineNumber;

        public Indent(int lineNumber, int size) {
            this.lineNumber = lineNumber;
            this.size = size;
        }

        public String toString() {
            return "Indent [size=" + this.size + ", lineNumber=" + this.lineNumber + "]";
        }
    }

    private static class ElementEntry {
        private final String elementName;
        private final Indent expectedIndent;
        private final Indent foundIndent;

        public ElementEntry(String elementName, Indent foundIndent) {
            this.elementName = elementName;
            this.foundIndent = foundIndent;
            this.expectedIndent = foundIndent;
        }

        public ElementEntry(String elementName, Indent foundIndent, Indent expectedIndent) {
            this.elementName = elementName;
            this.foundIndent = foundIndent;
            this.expectedIndent = expectedIndent;
        }

        public String toString() {
            return "<" + this.elementName + "> " + this.foundIndent;
        }
    }
}

