/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.drift.mongodb;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.Morphia;
import com.google.code.morphia.query.Criteria;
import com.google.code.morphia.query.Query;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.WriteConcern;
import com.mongodb.gridfs.GridFSDBFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.types.ObjectId;
import org.rhq.common.drift.ChangeSetReaderImpl;
import org.rhq.common.drift.FileEntry;
import org.rhq.common.drift.Headers;
import org.rhq.core.clientapi.agent.drift.DriftAgentService;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.DriftChangeSetCriteria;
import org.rhq.core.domain.criteria.DriftCriteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.drift.Drift;
import org.rhq.core.domain.drift.DriftChangeSet;
import org.rhq.core.domain.drift.DriftChangeSetCategory;
import org.rhq.core.domain.drift.DriftComposite;
import org.rhq.core.domain.drift.DriftConfigurationDefinition;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftFile;
import org.rhq.core.domain.drift.DriftFileStatus;
import org.rhq.core.domain.drift.dto.DriftChangeSetDTO;
import org.rhq.core.domain.drift.dto.DriftDTO;
import org.rhq.core.domain.drift.dto.DriftFileDTO;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.drift.DriftManagerLocal;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginContext;
import org.rhq.enterprise.server.plugin.pc.drift.DriftChangeSetSummary;
import org.rhq.enterprise.server.plugin.pc.drift.DriftServerPluginFacet;
import org.rhq.enterprise.server.plugins.drift.mongodb.Mapper;
import org.rhq.enterprise.server.plugins.drift.mongodb.dao.ChangeSetDAO;
import org.rhq.enterprise.server.plugins.drift.mongodb.dao.FileDAO;
import org.rhq.enterprise.server.plugins.drift.mongodb.entities.MongoDBChangeSet;
import org.rhq.enterprise.server.plugins.drift.mongodb.entities.MongoDBChangeSetEntry;
import org.rhq.enterprise.server.plugins.drift.mongodb.entities.MongoDBFile;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class MongoDBDriftServer
implements DriftServerPluginFacet,
ServerPluginComponent {
    private Log log = LogFactory.getLog(MongoDBDriftServer.class);
    private Mongo connection;
    private Morphia morphia;
    private Datastore ds;
    private ChangeSetDAO changeSetDAO;
    private FileDAO fileDAO;

    public Mongo getConnection() {
        return this.connection;
    }

    public void setConnection(Mongo connection) {
        this.connection = connection;
    }

    public Morphia getMorphia() {
        return this.morphia;
    }

    public void setMorphia(Morphia morphia) {
        this.morphia = morphia;
    }

    public Datastore getDatastore() {
        return this.ds;
    }

    public void setDatastore(Datastore ds) {
        this.ds = ds;
    }

    public ChangeSetDAO getChangeSetDAO() {
        return this.changeSetDAO;
    }

    public void setChangeSetDAO(ChangeSetDAO changeSetDAO) {
        this.changeSetDAO = changeSetDAO;
    }

    public FileDAO getFileDAO() {
        return this.fileDAO;
    }

    public void setFileDAO(FileDAO fileDAO) {
        this.fileDAO = fileDAO;
    }

    public void initialize(ServerPluginContext context) throws Exception {
        this.connection = new Mongo("127.0.0.1");
        this.morphia = new Morphia().map(MongoDBChangeSet.class).map(MongoDBChangeSetEntry.class).map(MongoDBFile.class);
        this.ds = this.morphia.createDatastore(this.connection, "rhq");
        this.changeSetDAO = new ChangeSetDAO(this.morphia, this.connection, "rhq");
        this.fileDAO = new FileDAO(this.ds.getDB());
        this.ds.setDefaultWriteConcern(WriteConcern.SAFE);
    }

    public void start() {
    }

    public void stop() {
    }

    public void shutdown() {
    }

    public DriftChangeSetSummary saveChangeSet(Subject subject, final int resourceId, File changeSetZip) throws Exception {
        final DriftChangeSetSummary summary = new DriftChangeSetSummary();
        ZipUtil.walkZipFile((File)changeSetZip, (ZipUtil.ZipEntryVisitor)new ZipUtil.ZipEntryVisitor(){

            public boolean visit(ZipEntry zipEntry, ZipInputStream stream) throws Exception {
                ChangeSetReaderImpl reader = new ChangeSetReaderImpl((Reader)new BufferedReader(new InputStreamReader(stream)));
                Headers headers = reader.getHeaders();
                LinkedList<DriftFileDTO> missingContent = new LinkedList<DriftFileDTO>();
                MongoDBChangeSet changeSet = new MongoDBChangeSet();
                changeSet.setCategory(headers.getType());
                changeSet.setResourceId(resourceId);
                changeSet.setDriftDefinitionId(headers.getDriftDefinitionId());
                changeSet.setDriftDefinitionName(headers.getDriftDefinitionName());
                changeSet.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
                changeSet.setVersion(headers.getVersion());
                summary.setCategory(headers.getType());
                summary.setResourceId(resourceId);
                summary.setDriftDefinitionName(headers.getDriftDefinitionName());
                summary.setCreatedTime(changeSet.getCtime().longValue());
                for (FileEntry fileEntry : reader) {
                    String path = FileUtil.useForwardSlash((String)fileEntry.getFile());
                    MongoDBChangeSetEntry entry = new MongoDBChangeSetEntry(path, fileEntry.getType());
                    switch (fileEntry.getType()) {
                        case FILE_ADDED: {
                            entry.setNewFileHash(fileEntry.getNewSHA());
                            if (MongoDBDriftServer.this.fileDAO.findOne(fileEntry.getNewSHA()) != null) break;
                            missingContent.add(MongoDBDriftServer.this.newDriftFile(fileEntry.getNewSHA()));
                            break;
                        }
                        case FILE_CHANGED: {
                            entry.setOldFileHash(fileEntry.getOldSHA());
                            entry.setNewFileHash(fileEntry.getNewSHA());
                            if (MongoDBDriftServer.this.fileDAO.findOne(fileEntry.getNewSHA()) == null) {
                                missingContent.add(MongoDBDriftServer.this.newDriftFile(fileEntry.getNewSHA()));
                            }
                            if (MongoDBDriftServer.this.fileDAO.findOne(fileEntry.getOldSHA()) != null) break;
                            missingContent.add(MongoDBDriftServer.this.newDriftFile(fileEntry.getNewSHA()));
                            break;
                        }
                        default: {
                            entry.setOldFileHash(fileEntry.getOldSHA());
                            if (MongoDBDriftServer.this.fileDAO.findOne(fileEntry.getOldSHA()) != null) break;
                            missingContent.add(MongoDBDriftServer.this.newDriftFile(fileEntry.getOldSHA()));
                        }
                    }
                    changeSet.add(entry);
                    if (headers.getType() != DriftChangeSetCategory.DRIFT) continue;
                    summary.addDriftPathname(path);
                }
                MongoDBDriftServer.this.ds.save((Object)changeSet);
                DriftAgentService driftService = MongoDBDriftServer.this.getDriftAgentService(resourceId);
                driftService.ackChangeSet(headers.getResourceId(), headers.getDriftDefinitionName());
                if (!missingContent.isEmpty()) {
                    driftService.requestDriftFiles(resourceId, headers, missingContent);
                }
                return true;
            }
        });
        return summary;
    }

    protected DriftAgentService getDriftAgentService(int resourceId) {
        AgentClient agent = LookupUtil.getAgentManager().getAgentClient(LookupUtil.getSubjectManager().getOverlord(), resourceId);
        return agent.getDriftAgentService();
    }

    private DriftFileDTO newDriftFile(String hash) {
        DriftFileDTO file = new DriftFileDTO();
        file.setHashId(hash);
        return file;
    }

    private DriftFileDTO newDriftFile(String hash, DriftFileStatus status) {
        DriftFileDTO file = new DriftFileDTO();
        file.setHashId(hash);
        file.setStatus(status);
        return file;
    }

    public void saveChangeSetFiles(Subject subject, File changeSetFilesZip) throws Exception {
        String zipFileName = changeSetFilesZip.getName();
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File dir = new File(tmpDir, zipFileName.substring(0, zipFileName.indexOf(".")));
        dir.mkdir();
        ZipUtil.unzipFile((File)changeSetFilesZip, (File)dir);
        for (File file : dir.listFiles()) {
            this.fileDAO.save(file);
            file.delete();
        }
    }

    public PageList<? extends DriftChangeSet<?>> findDriftChangeSetsByCriteria(Subject subject, DriftChangeSetCriteria criteria) {
        Mapper mapper = new Mapper();
        List<MongoDBChangeSet> changeSets = this.changeSetDAO.findByChangeSetCritiera(criteria);
        PageList results = new PageList();
        for (MongoDBChangeSet changeSet : changeSets) {
            DriftChangeSetDTO changeSetDTO = mapper.toDTO(changeSet);
            if (criteria.isFetchDrifts()) {
                HashSet<DriftDTO> entries = new HashSet<DriftDTO>();
                for (MongoDBChangeSetEntry entry : changeSet.getDrifts()) {
                    DriftDTO driftDTO = mapper.toDTO(entry);
                    driftDTO.setChangeSet(changeSetDTO);
                    entries.add(driftDTO);
                }
                changeSetDTO.setDrifts(entries);
            }
            results.add((Object)changeSetDTO);
        }
        return results;
    }

    public PageList<? extends Drift<?, ?>> findDriftsByCriteria(Subject subject, DriftCriteria criteria) {
        Mapper mapper = new Mapper();
        List<MongoDBChangeSetEntry> entries = this.changeSetDAO.findEntries(criteria);
        PageList results = new PageList();
        for (MongoDBChangeSetEntry entry : entries) {
            DriftDTO driftDTO = mapper.toDTO(entry);
            if (criteria.isFetchChangeSet()) {
                driftDTO.setChangeSet(mapper.toDTO(entry.getChangeSet()));
            }
            results.add((Object)driftDTO);
        }
        return results;
    }

    public PageList<DriftComposite> findDriftCompositesByCriteria(Subject subject, DriftCriteria criteria) {
        Mapper mapper = new Mapper();
        List<MongoDBChangeSetEntry> entries = this.changeSetDAO.findEntries(criteria);
        Map<Integer, Resource> resources = this.loadResourceMap(subject, criteria.getFilterResourceIds());
        PageList results = new PageList();
        for (MongoDBChangeSetEntry entry : entries) {
            MongoDBChangeSet changeSet = entry.getChangeSet();
            DriftDTO driftDTO = mapper.toDTO(entry);
            if (criteria.isFetchChangeSet()) {
                DriftChangeSetDTO changeSetDTO = mapper.toDTO(changeSet);
                driftDTO.setChangeSet(changeSetDTO);
            }
            results.add((Object)new DriftComposite((Drift)driftDTO, resources.get(changeSet.getResourceId()), changeSet.getDriftDefinitionName()));
        }
        return results;
    }

    public DriftFile getDriftFile(Subject subject, String hashId) throws Exception {
        GridFSDBFile gridFSDBFile = this.fileDAO.findById(hashId);
        if (gridFSDBFile == null) {
            return null;
        }
        return this.newDriftFile(hashId, DriftFileStatus.LOADED);
    }

    public void purgeByDriftDefinitionName(Subject subject, int resourceId, String driftDefName) throws Exception {
        this.changeSetDAO.deleteChangeSets(resourceId, driftDefName);
    }

    public int purgeOrphanedDriftFiles(Subject subject, long purgeMillis) {
        return 0;
    }

    public void purgeOrphanedContent() {
        for (DBObject object : this.fileDAO.getFileListCursor()) {
            String id = (String)object.get("_id");
            Query query = this.ds.createQuery(MongoDBChangeSet.class);
            query.or(new Criteria[]{(Criteria)query.criteria("files.newFileHash").equal((Object)id), (Criteria)query.criteria("files.oldFileHash").equal((Object)id)});
            query.limit(1);
            if (query.get() != null) continue;
            this.fileDAO.delete(id);
        }
    }

    public String getDriftFileBits(Subject subject, String hash) {
        GridFSDBFile file = this.fileDAO.findById(hash);
        if (file == null) {
            return null;
        }
        return new String(StreamUtil.slurp((InputStream)file.getInputStream()));
    }

    Map<Integer, Resource> loadResourceMap(Subject subject, Integer[] resourceIds) {
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.addFilterIds(resourceIds);
        ResourceManagerLocal resourceMgr = LookupUtil.getResourceManager();
        PageList resources = resourceMgr.findResourcesByCriteria(subject, criteria);
        HashMap<Integer, Resource> map = new HashMap<Integer, Resource>();
        for (Resource r : resources) {
            map.put(r.getId(), r);
        }
        return map;
    }

    public String persistChangeSet(Subject subject, DriftChangeSet<?> changeSet) {
        MongoDBChangeSet newChangeSet = new MongoDBChangeSet();
        newChangeSet.setResourceId(changeSet.getResourceId());
        newChangeSet.setDriftDefinitionId(changeSet.getDriftDefinitionId());
        newChangeSet.setDriftHandlingMode(changeSet.getDriftHandlingMode());
        newChangeSet.setCategory(changeSet.getCategory());
        newChangeSet.setDriftDefinitionId(changeSet.getDriftDefinitionId());
        if (!this.isTemplateChangeSet(changeSet)) {
            DriftDefinition driftDef = this.getDriftDef(subject, changeSet.getDriftDefinitionId());
            if (driftDef == null) {
                throw new IllegalArgumentException("Cannot persist change set. " + DriftDefinition.class.getSimpleName() + " with id " + changeSet.getDriftDefinitionId() + " cannot be found.");
            }
            newChangeSet.setDriftDefinitionName(driftDef.getName());
        }
        for (Drift drift : changeSet.getDrifts()) {
            MongoDBChangeSetEntry entry = new MongoDBChangeSetEntry();
            entry.setPath(drift.getPath());
            entry.setCategory(drift.getCategory());
            entry.setNewFileHash(drift.getNewDriftFile().getHashId());
            newChangeSet.add(entry);
        }
        this.changeSetDAO.save(newChangeSet);
        return newChangeSet.getId();
    }

    private boolean isTemplateChangeSet(DriftChangeSet<?> changeSet) {
        return changeSet.getResourceId() == 0 && changeSet.getDriftDefinitionId() == 0;
    }

    public String copyChangeSet(Subject subject, String changeSetId, int driftDefId, int resourceId) {
        MongoDBChangeSet changeSet = (MongoDBChangeSet)this.changeSetDAO.findOne("id", new ObjectId(changeSetId));
        changeSet.setDriftDefinitionId(driftDefId);
        changeSet.setResourceId(resourceId);
        changeSet.setId(new ObjectId());
        this.changeSetDAO.save(changeSet);
        return changeSet.getId();
    }

    public byte[] getDriftFileAsByteArray(Subject subject, String hash) {
        GridFSDBFile file = this.fileDAO.findById(hash);
        if (file == null) {
            return null;
        }
        return StreamUtil.slurp((InputStream)file.getInputStream());
    }

    protected DriftDefinition getDriftDef(Subject subject, int id) {
        DriftManagerLocal driftMgr = LookupUtil.getDriftManager();
        return driftMgr.getDriftDefinition(subject, id);
    }
}

