/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.drift.mongodb.entities;

import com.google.code.morphia.annotations.Embedded;
import com.google.code.morphia.annotations.Entity;
import com.google.code.morphia.annotations.Id;
import com.google.code.morphia.annotations.PostLoad;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.bson.types.ObjectId;
import org.rhq.core.domain.drift.DriftChangeSet;
import org.rhq.core.domain.drift.DriftChangeSetCategory;
import org.rhq.core.domain.drift.DriftConfigurationDefinition;
import org.rhq.enterprise.server.plugins.drift.mongodb.entities.MongoDBChangeSetEntry;

@Entity(value="changesets")
public class MongoDBChangeSet
implements DriftChangeSet<MongoDBChangeSetEntry>,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    private ObjectId id = new ObjectId();
    private Long ctime = System.currentTimeMillis();
    private int version;
    private DriftChangeSetCategory category;
    private int driftDefId;
    private DriftConfigurationDefinition.DriftHandlingMode driftHandlingMode;
    private int resourceId;
    private String driftDefName;
    @Embedded(value="files")
    private List<MongoDBChangeSetEntry> entries = new ArrayList<MongoDBChangeSetEntry>();

    public ObjectId getObjectId() {
        return this.id;
    }

    public String getId() {
        return this.id.toString();
    }

    public void setId(String id) {
        this.id = new ObjectId(id);
    }

    public void setId(ObjectId id) {
        this.id = id;
    }

    public Long getCtime() {
        return this.ctime;
    }

    public void setCtime(Long ctime) {
        this.ctime = ctime;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public DriftChangeSetCategory getCategory() {
        return this.category;
    }

    public void setCategory(DriftChangeSetCategory category) {
        this.category = category;
    }

    public int getDriftDefinitionId() {
        return this.driftDefId;
    }

    public void setDriftDefinitionId(int id) {
        this.driftDefId = id;
    }

    public String getDriftDefinitionName() {
        return this.driftDefName;
    }

    public void setDriftDefinitionName(String name) {
        this.driftDefName = name;
    }

    public DriftConfigurationDefinition.DriftHandlingMode getDriftHandlingMode() {
        return this.driftHandlingMode;
    }

    public void setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode driftHandlingMode) {
        this.driftHandlingMode = driftHandlingMode;
    }

    public int getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(int id) {
        this.resourceId = id;
    }

    public Set<MongoDBChangeSetEntry> getDrifts() {
        return new LinkedHashSet<MongoDBChangeSetEntry>(this.entries);
    }

    public MongoDBChangeSet add(MongoDBChangeSetEntry entry) {
        this.entries.add(entry);
        entry.setIndex(this.entries.size() - 1);
        entry.setChangeSet(this);
        return this;
    }

    public void setDrifts(Set<MongoDBChangeSetEntry> drifts) {
        for (MongoDBChangeSetEntry entry : drifts) {
            this.add(entry);
        }
    }

    @PostLoad
    void initEntries() {
        for (MongoDBChangeSetEntry entry : this.entries) {
            entry.setChangeSet(this);
        }
    }
}

