/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import mazz.i18n.Logger;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.agent.AgentInputReader;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentPrintWriter;
import org.rhq.enterprise.agent.AgentShutdownHook;
import org.rhq.enterprise.agent.AgentUpdateDownload;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;

public class AgentUpdateThread
extends Thread {
    private static final String THREAD_NAME = "RHQ Agent Update Thread";
    private final Logger log = AgentI18NFactory.getLogger(AgentUpdateThread.class);
    private final AgentMain agent;
    private AgentPrintWriter console;
    private static AtomicBoolean updating = new AtomicBoolean(false);

    public static void updateAgentNow(AgentMain agent, boolean wait) throws IllegalStateException {
        AgentUpdateThread updateThread;
        if (!agent.getConfiguration().isAgentUpdateEnabled()) {
            throw new UnsupportedOperationException(agent.getI18NMsg().getMsg("AgentUpdateDownload.update-download-disabled-by-agent", new Object[0]));
        }
        AgentUpdateThread.lock(agent);
        try {
            updateThread = new AgentUpdateThread(agent);
            updateThread.start();
        }
        catch (Throwable t) {
            AgentUpdateThread.unlock();
            updateThread = null;
        }
        if (wait && updateThread != null) {
            while (updateThread.isAlive()) {
                try {
                    updateThread.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            Thread.currentThread().interrupt();
        }
    }

    public static boolean isUpdatingNow() {
        return updating.get();
    }

    private AgentUpdateThread(AgentMain agent) {
        super(THREAD_NAME);
        this.setDaemon(false);
        this.agent = agent;
        this.console = agent.getOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AgentShutdownHook shutdownHook = new AgentShutdownHook(this.agent);
        int attempts = 0;
        boolean tryAgain = true;
        while (tryAgain && !this.isInterrupted()) {
            try {
                AgentUpdateDownload aud;
                this.showMessage("AgentUpdateThread.started", new Object[0]);
                if (this.agent.isStarted()) {
                    this.agent.shutdown();
                }
                int numThreadsStillAlive = shutdownHook.waitForNonDaemonThreads();
                try {
                    aud = new AgentUpdateDownload(this.agent);
                    aud.download();
                    aud.validate();
                    this.showMessage("PromptCommand.update.downloaded", aud.getAgentUpdateBinaryFile());
                }
                catch (Exception e) {
                    this.showErrorMessage("PromptCommand.update.download-failed", e.getMessage());
                    throw e;
                }
                String javaExe = this.findJavaExe();
                ArrayList<String> args = new ArrayList<String>();
                args.add("-jar");
                args.add(aud.getAgentUpdateBinaryFile().getAbsolutePath());
                args.add("--pause=" + (numThreadsStillAlive > 0 ? "80000" : "20000"));
                args.add("--update=" + this.agent.getAgentHomeDirectory());
                SystemInfo sysInfo = SystemInfoFactory.createSystemInfo();
                ProcessExecution processExecution = new ProcessExecution(javaExe);
                processExecution.setArguments(args);
                processExecution.setWorkingDirectory(new File(this.agent.getAgentHomeDirectory()).getParent());
                processExecution.setCaptureOutput(false);
                processExecution.setWaitForCompletion(0L);
                this.showMessage("AgentUpdateThread.executing-update-process", processExecution);
                ProcessExecutionResults results = sysInfo.executeProcess(processExecution);
                if (results.getError() != null) {
                    throw results.getError();
                }
                try {
                    AgentInputReader in = this.agent.getIn();
                    if (in == null) continue;
                    System.in.close();
                    in.close();
                }
                catch (Throwable t) {}
                continue;
                finally {
                    tryAgain = false;
                }
            }
            catch (Throwable t) {
                this.showErrorMessage("AgentUpdateThread.exception", ThrowableUtil.getAllMessages((Throwable)t));
                if (++attempts % 5 == 0) {
                    this.showFinalFailureMessage(attempts);
                }
                long pause = 60000L;
                this.showErrorMessage("AgentUpdateThread.cannot-restart-retry", 60000L);
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        shutdownHook.spawnKillThread(60000L);
    }

    private String findJavaExe() throws Exception {
        String envName = "RHQ_JAVA_EXE_FILE_PATH";
        String envString = System.getenv(envName);
        if (envString != null) {
            this.showMessage("AgentUpdateThread.using-java-exe", envString);
            return envString;
        }
        envName = "RHQ_AGENT_JAVA_EXE_FILE_PATH";
        envString = System.getenv(envName);
        if (envString != null) {
            this.showMessage("AgentUpdateThread.using-java-exe", envString);
            return envString;
        }
        this.showMessage("AgentUpdateThread.looking-for-java-exe", envName);
        String javaExe = "java";
        String javaHome = System.getProperty("java.home");
        if (javaHome != null) {
            File[] guesses;
            for (File guess : guesses = new File[]{new File(javaHome, "bin/java"), new File(javaHome, "bin/java.exe"), new File(javaHome, "java"), new File(javaHome, "java.exe")}) {
                if (!guess.isFile()) continue;
                javaExe = guess.getAbsolutePath();
                break;
            }
        }
        this.showMessage("AgentUpdateThread.using-java-exe", javaExe);
        return javaExe;
    }

    private static void lock(AgentMain agent) throws IllegalStateException {
        if (!updating.compareAndSet(false, true)) {
            throw new IllegalStateException(agent.getI18NMsg().getMsg("AgentUpdateThread.duplicate", new Object[0]));
        }
    }

    private static void unlock() {
        updating.set(false);
    }

    private void showMessage(String msg, Object ... args) {
        this.log.info(msg, args);
        this.console.println(this.agent.getI18NMsg().getMsg(msg, args));
    }

    private void showErrorMessage(String msg, Object ... args) {
        try {
            this.log.fatal(msg, args);
            this.console.println(this.agent.getI18NMsg().getMsg(msg, args));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void showFinalFailureMessage(int attempts) {
        try {
            this.log.fatal("AgentUpdateThread.failure", new Object[]{attempts});
            this.console.println(this.agent.getI18NMsg().getMsg("AgentUpdateThread.failure", new Object[]{attempts}));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

