/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;
import mazz.i18n.Logger;
import org.rhq.enterprise.agent.AgentConfiguration;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.AgentRestartCounter;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;

public class VMHealthCheckThread
extends Thread {
    private static final Logger LOG = AgentI18NFactory.getLogger(VMHealthCheckThread.class);
    private final AgentMain agent;
    private final long interval;
    private final float heapThreshold;
    private final float nonheapThreshold;
    private final boolean performGC;
    private final List<String> memoryPoolsToMonitor;

    public VMHealthCheckThread(AgentMain agent) {
        super("RHQ VM Health Check Thread");
        this.setDaemon(false);
        this.agent = agent;
        AgentConfiguration config = agent.getConfiguration();
        if (config != null) {
            this.interval = config.getVMHealthCheckIntervalMsecs();
            this.heapThreshold = config.getVMHealthCheckLowHeapMemThreshold();
            this.nonheapThreshold = config.getVMHealthCheckLowNonHeapMemThreshold();
        } else {
            this.interval = 5000L;
            this.heapThreshold = 0.9f;
            this.nonheapThreshold = 0.9f;
        }
        this.memoryPoolsToMonitor = new ArrayList<String>();
        String memoryPoolNames = System.getProperty("rhq.agent.vm-health-check.mem-pools-to-check", "perm gen");
        for (String memoryPoolName : memoryPoolNames.split(",")) {
            this.memoryPoolsToMonitor.add(memoryPoolName.toLowerCase());
        }
        String gcProp = System.getProperty("rhq.agent.vm-health-check.perform-gc", "true");
        this.performGC = Boolean.parseBoolean(gcProp);
    }

    public void stopChecking() {
        this.interrupt();
        try {
            this.join(this.interval);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    boolean isOutOfMemory() {
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        List<MemoryPoolMXBean> memoryPoolMxBeans = this.getMemoryPoolMXBeansToMonitor();
        return this.checkMemory(memoryMxBean) || this.checkPoolMemories(memoryPoolMxBeans, memoryMxBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.debug("VMHealthCheckThread.started", new Object[]{this.interval});
        try {
            VMHealthCheckThread vMHealthCheckThread = this;
            synchronized (vMHealthCheckThread) {
                this.wait(this.interval);
            }
            while (!this.isInterrupted()) {
                try {
                    if (this.isOutOfMemory()) {
                        LOG.fatal("VMHealthCheckThread.mem-problem", new Object[0]);
                        this.restartAgent(60000L);
                        continue;
                    }
                    vMHealthCheckThread = this;
                    synchronized (vMHealthCheckThread) {
                        this.wait(this.interval);
                    }
                }
                catch (VirtualMachineError vme) {
                    this.restartAgent(0L);
                }
            }
        }
        catch (InterruptedException e) {
        }
        catch (Throwable t) {
            LOG.error("VMHealthCheckThread.exception", new Object[]{t});
        }
        LOG.debug("VMHealthCheckThread.stopped", new Object[0]);
    }

    private void restartAgent(long pause) throws Exception {
        try {
            this.agent.shutdown();
        }
        catch (Throwable t) {
            Thread.interrupted();
            Thread.sleep(30000L);
            return;
        }
        if (pause > 0L) {
            Thread.sleep(pause);
        }
        try {
            this.agent.start();
        }
        catch (Throwable t) {
            try {
                this.agent.shutdown();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            Thread.interrupted();
            return;
        }
        this.agent.getAgentRestartCounter().restartedAgent(AgentRestartCounter.AgentRestartReason.VM_HEALTH_CHECK);
        this.interrupt();
    }

    private boolean checkMemory(MemoryMXBean bean) {
        boolean nonheapCritical;
        boolean heapCritical;
        block5: {
            heapCritical = false;
            nonheapCritical = false;
            try {
                heapCritical = this.isCriticallyLow(bean.getHeapMemoryUsage(), this.heapThreshold, "VM heap");
                nonheapCritical = this.isCriticallyLow(bean.getNonHeapMemoryUsage(), this.nonheapThreshold, "VM nonheap");
                if (!heapCritical && !nonheapCritical) break block5;
                try {
                    if (this.performGC) {
                        LOG.warn("VMHealthCheckThread.gc", new Object[0]);
                        bean.gc();
                    }
                    heapCritical = this.isCriticallyLow(bean.getHeapMemoryUsage(), this.heapThreshold, "VM heap");
                    nonheapCritical = this.isCriticallyLow(bean.getNonHeapMemoryUsage(), this.nonheapThreshold, "VM nonheap");
                }
                catch (Throwable t) {
                    return true;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return heapCritical || nonheapCritical;
    }

    private boolean checkPoolMemories(List<MemoryPoolMXBean> memoryPoolMxBeans, MemoryMXBean memoryMxBean) {
        boolean critical = false;
        boolean allValid = true;
        try {
            for (MemoryPoolMXBean bean : memoryPoolMxBeans) {
                if (bean.isValid()) {
                    critical = this.isCriticallyLow(bean.getUsage(), this.heapThreshold, bean.getName());
                    if (!critical) continue;
                    try {
                        if (this.performGC) {
                            LOG.warn("VMHealthCheckThread.gc", new Object[0]);
                            memoryMxBean.gc();
                        }
                        critical = this.isCriticallyLow(bean.getUsage(), this.heapThreshold, bean.getName());
                        continue;
                    }
                    catch (Throwable t) {
                        return true;
                    }
                }
                allValid = false;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (!critical && !allValid) {
            memoryPoolMxBeans.clear();
            memoryPoolMxBeans.addAll(this.getMemoryPoolMXBeansToMonitor());
        }
        return critical;
    }

    private boolean isCriticallyLow(MemoryUsage memoryUsage, float thresholdPercentage, String type) {
        long used = memoryUsage.getUsed();
        long max = memoryUsage.getMax();
        if (max > -1L && (float)used > (float)max * thresholdPercentage) {
            LOG.warn("VMHealthCheckThread.mem-low", new Object[]{type, Float.valueOf(thresholdPercentage), memoryUsage});
            return true;
        }
        return false;
    }

    private List<MemoryPoolMXBean> getMemoryPoolMXBeansToMonitor() {
        ArrayList<MemoryPoolMXBean> memoryPoolMxBeansToMonitor = new ArrayList<MemoryPoolMXBean>();
        if (!this.memoryPoolsToMonitor.isEmpty()) {
            List<MemoryPoolMXBean> allMemoryPoolMxBeans = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean memoryPoolMXBean : allMemoryPoolMxBeans) {
                if (!this.memoryPoolsToMonitor.contains(memoryPoolMXBean.getName().toLowerCase())) continue;
                memoryPoolMxBeansToMonitor.add(memoryPoolMXBean);
            }
        }
        return memoryPoolMxBeansToMonitor;
    }
}

