/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.agent.promptcmd;

import mazz.i18n.Msg;
import org.rhq.enterprise.agent.AgentMain;
import org.rhq.enterprise.agent.i18n.AgentI18NFactory;
import org.rhq.enterprise.agent.promptcmd.AgentPromptCommand;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.client.CmdlineClient;

public class ServerCommandPromptCommand
implements AgentPromptCommand {
    private static final Msg MSG = AgentI18NFactory.getMsg();

    @Override
    public String getPromptCommandString() {
        return MSG.getMsg("PromptCommand.server", new Object[0]);
    }

    @Override
    public boolean execute(AgentMain agent, String[] args) {
        try {
            String[] remoteCmdArgs = new String[args.length - 1];
            System.arraycopy(args, 1, remoteCmdArgs, 0, remoteCmdArgs.length);
            CmdlineClient client = new CmdlineClient();
            Command command = client.buildCommand(remoteCmdArgs);
            agent.getOut().println(MSG.getMsg("PromptCommand.server.sending", new Object[0]));
            CommandResponse response = agent.getClientCommandSender().sendSynch(command);
            agent.getOut().println(response);
        }
        catch (Exception e) {
            throw new RuntimeException(MSG.getMsg("PromptCommand.server.failure", new Object[0]), e);
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return MSG.getMsg("PromptCommand.server.syntax", new Object[0]);
    }

    @Override
    public String getHelp() {
        return MSG.getMsg("PromptCommand.server.help", new Object[0]);
    }

    @Override
    public String getDetailedHelp() {
        return MSG.getMsg("PromptCommand.server.detailed-help", new Object[]{new CmdlineClient().getUsage()});
    }
}

