/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.agent.discovery;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.discovery.InvalidPluginConfigurationClientException;
import org.rhq.core.clientapi.server.discovery.InventoryReport;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.discovery.MergeResourceResponse;
import org.rhq.core.domain.discovery.PlatformSyncInfo;
import org.rhq.core.domain.discovery.ResourceSyncInfo;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;

public interface DiscoveryAgentService {
    public void updatePluginConfiguration(int var1, Configuration var2) throws InvalidPluginConfigurationClientException, PluginContainerException;

    public void synchronizePlatform(PlatformSyncInfo var1);

    public void synchronizeServer(int var1, Collection<ResourceSyncInfo> var2);

    public Resource getPlatform();

    @NotNull
    public InventoryReport executeServerScanImmediately() throws PluginContainerException;

    @NotNull
    public InventoryReport executeServiceScanImmediately() throws PluginContainerException;

    public void executeServiceScanDeferred();

    public AvailabilityReport executeAvailabilityScanImmediately(boolean var1);

    @NotNull
    public AvailabilityReport getCurrentAvailability(Resource var1, boolean var2);

    public void requestFullAvailabilityReport();

    public MergeResourceResponse manuallyAddResource(ResourceType var1, int var2, Configuration var3, int var4) throws InvalidPluginConfigurationClientException, PluginContainerException;

    public void uninventoryResource(int var1);

    public void enableServiceScans(int var1, Configuration var2);

    public void disableServiceScans(int var1);
}

