/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.util;

import java.io.File;
import java.io.FilenameFilter;

public class ResponseTimeLogFinder {
    public static final File FALLBACK_RESPONSE_TIME_LOG_FILE_DIRECTORY = new File(System.getProperty("java.io.tmpdir") + File.separator + "rhq" + File.separator + "rt");

    private ResponseTimeLogFinder() {
    }

    public static String findResponseTimeLogFileInDirectory(String contextPath, File responseTimeLogFileDirectory) {
        String rtFileSuffix;
        File[] files;
        if (contextPath == null) {
            throw new IllegalArgumentException("contextPath is null");
        }
        if (!contextPath.startsWith("/")) {
            throw new IllegalArgumentException("contextPath does not start with '/': " + contextPath);
        }
        if (responseTimeLogFileDirectory == null) {
            throw new IllegalArgumentException("responseTimeLogFileDirectory is null");
        }
        if (responseTimeLogFileDirectory.exists() && responseTimeLogFileDirectory.isDirectory() && (files = responseTimeLogFileDirectory.listFiles(new FilenameFilter(rtFileSuffix = (contextPath.equals("/") ? "ROOT" : contextPath).substring(1).replace('/', '_') + "_rt.log"){
            final /* synthetic */ String val$rtFileSuffix;
            {
                this.val$rtFileSuffix = string;
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(this.val$rtFileSuffix);
            }
        })) != null && files.length == 1) {
            return files[0].getAbsolutePath();
        }
        return null;
    }
}

