/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.agent;

import java.io.InputStream;
import java.io.OutputStream;
import org.rhq.core.pc.agent.AgentServiceStreamRemoter;

public abstract class AgentService {
    private final Class clientInterface;
    private final AgentServiceStreamRemoter streamRemoter;

    protected AgentService(Class clientInterface, AgentServiceStreamRemoter streamRemoter) {
        this.clientInterface = clientInterface;
        this.streamRemoter = streamRemoter;
    }

    protected InputStream remoteInputStream(InputStream inputStream) {
        if (inputStream == null || this.streamRemoter == null) {
            return inputStream;
        }
        return this.streamRemoter.prepareInputStream(inputStream);
    }

    protected OutputStream remoteOutputStream(OutputStream outputStream) {
        if (outputStream == null || this.streamRemoter == null) {
            return outputStream;
        }
        return this.streamRemoter.prepareOutputStream(outputStream);
    }

    public Class getClientInterface() {
        return this.clientInterface;
    }

    protected AgentServiceStreamRemoter getStreamRemoter() {
        return this.streamRemoter;
    }
}

