/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.availability;

import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pluginapi.availability.AvailabilityCollectorRunnable;
import org.rhq.core.pluginapi.availability.AvailabilityContext;
import org.rhq.core.pluginapi.availability.AvailabilityFacet;

public class AvailabilityContextImpl
implements AvailabilityContext {
    private final Resource resource;
    private final InventoryManager inventoryManager;

    public AvailabilityContextImpl(Resource resource, InventoryManager inventoryManager) {
        this.resource = resource;
        this.inventoryManager = inventoryManager;
    }

    @Deprecated
    public AvailabilityCollectorRunnable createAvailabilityCollectorRunnable(AvailabilityFacet facet, long i) {
        return new AvailabilityCollectorRunnable(facet, i, null, null);
    }

    public void requestAvailabilityCheck() {
        this.inventoryManager.requestAvailabilityCheck(this.resource);
    }

    public AvailabilityType getLastReportedAvailability() {
        Availability avail = this.inventoryManager.getAvailabilityIfKnown(this.resource);
        return null != avail ? avail.getAvailabilityType() : null;
    }

    public void disable() {
        this.inventoryManager.setResourceEnablement(this.resource.getId(), false);
    }

    public void enable() {
        this.inventoryManager.setResourceEnablement(this.resource.getId(), true);
    }

    public Resource getResource() {
        return this.resource;
    }
}

