/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.server.configuration.ConfigurationServerService;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUtility;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;

public class ConfigurationCheckExecutor
implements Runnable,
Callable {
    private static final Log log = LogFactory.getLog(ConfigurationCheckExecutor.class);
    private ConfigurationServerService configurationServerService;
    private static final long CONFIGURATION_CHECK_TIMEOUT = 30000L;

    public ConfigurationCheckExecutor(ConfigurationServerService configurationServerService) {
        this.configurationServerService = configurationServerService;
    }

    @Override
    public void run() {
        this.call();
    }

    public Object call() {
        log.info((Object)"Starting configuration update check...");
        long start = System.currentTimeMillis();
        InventoryManager inventoryManager = PluginContainer.getInstance().getInventoryManager();
        Resource platform = inventoryManager.getPlatform();
        CountTime countTime = this.checkConfigurations(inventoryManager, platform, true);
        log.info((Object)("Configuration update check for [" + countTime.count + "] resources completed in " + (System.currentTimeMillis() - start) / 1000L + "s wall time, " + countTime.time + "ms check time"));
        return null;
    }

    public CountTime checkConfigurations(InventoryManager inventoryManager, Resource resource, boolean checkChildren) {
        ResourceContainer resourceContainer = inventoryManager.getResourceContainer(resource.getId());
        ConfigurationFacet resourceComponent = null;
        ResourceType resourceType = resource.getResourceType();
        CountTime countTime = new CountTime();
        boolean debugEnabled = log.isDebugEnabled();
        if (resourceContainer != null && resourceContainer.getAvailability() != null && resourceContainer.getAvailability().getAvailabilityType() == AvailabilityType.UP) {
            if (resourceContainer.supportsFacet(ConfigurationFacet.class)) {
                try {
                    resourceComponent = resourceContainer.createResourceComponentProxy(ConfigurationFacet.class, FacetLockType.NONE, 30000L, true, false, true);
                }
                catch (PluginContainerException e) {
                    // empty catch block
                }
            }
            if (resourceComponent != null && resource.getInventoryStatus() == InventoryStatus.COMMITTED && resourceType.getResourceConfigurationDefinition() != null) {
                long t1 = System.currentTimeMillis();
                if (debugEnabled) {
                    log.debug((Object)("Checking for updated Resource configuration for " + resource + "..."));
                }
                try {
                    Configuration liveConfiguration = resourceComponent.loadResourceConfiguration();
                    if (liveConfiguration != null) {
                        ConfigurationDefinition configurationDefinition = resourceType.getResourceConfigurationDefinition();
                        ConfigurationUtility.normalizeConfiguration((Configuration)liveConfiguration, (ConfigurationDefinition)configurationDefinition, (boolean)true, (boolean)true);
                        List errorMessages = ConfigurationUtility.validateConfiguration((Configuration)liveConfiguration, (ConfigurationDefinition)configurationDefinition);
                        for (String errorMessage : errorMessages) {
                            log.warn((Object)("Plugin Error: Invalid " + resourceType.getName() + " resource configuration returned by " + resourceType.getPlugin() + " plugin - " + errorMessage));
                        }
                        Configuration original = ConfigurationCheckExecutor.getResourceConfiguration(inventoryManager, resource);
                        if (original == null) {
                            original = ConfigurationCheckExecutor.loadConfigurationFromFile(inventoryManager, resource.getId());
                        }
                        if (!liveConfiguration.equals((Object)original)) {
                            if (debugEnabled) {
                                log.debug((Object)("New configuration version detected on resource: " + resource));
                            }
                            this.configurationServerService.persistUpdatedResourceConfiguration(resource.getId(), liveConfiguration);
                            boolean persisted = ConfigurationCheckExecutor.persistConfigurationToFile(inventoryManager, resource.getId(), liveConfiguration, log);
                            if (persisted) {
                                resource.setResourceConfiguration(null);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    log.warn((Object)("An error occurred while checking for an updated Resource configuration for " + resource + "."), t);
                }
                long now = System.currentTimeMillis();
                countTime.add(1L, now - t1);
                try {
                    Thread.sleep(750L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (checkChildren) {
                for (Resource child : inventoryManager.getContainerChildren(resource, resourceContainer)) {
                    try {
                        CountTime inner = this.checkConfigurations(inventoryManager, child, true);
                        countTime.add(inner.count, inner.time);
                    }
                    catch (Exception e) {
                        log.error((Object)("Failed to check Resource configuration for " + child + "."), (Throwable)e);
                    }
                }
            }
        }
        return countTime;
    }

    public static Configuration getResourceConfiguration(InventoryManager inventoryManager, Resource resource) {
        Configuration result = resource.getResourceConfiguration();
        if (null == result) {
            result = ConfigurationCheckExecutor.loadConfigurationFromFile(inventoryManager, resource.getId());
        }
        return result;
    }

    public static boolean persistConfigurationToFile(InventoryManager inventoryManager, int resourceId, Configuration liveConfiguration, Log log) {
        boolean success = true;
        try {
            File baseDataDir = inventoryManager.getDataDirectory();
            String pathname = "rc/" + String.valueOf(resourceId / 1000);
            File dataDir = new File(baseDataDir, pathname);
            if (!dataDir.exists() && !(success = dataDir.mkdirs())) {
                log.warn((Object)("Could not create data dir " + dataDir.getAbsolutePath()));
                return false;
            }
            File file = new File(dataDir, String.valueOf(resourceId));
            FileOutputStream fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(liveConfiguration);
            oos.flush();
            oos.close();
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            log.warn((Object)("Persisting failed: " + e.getMessage()));
            success = false;
        }
        return success;
    }

    private static Configuration loadConfigurationFromFile(InventoryManager inventoryManager, int resourceId) {
        String pathname;
        File baseDataDir = inventoryManager.getDataDirectory();
        File dataDir = new File(baseDataDir, pathname = "rc/" + String.valueOf(resourceId / 1000));
        File file = new File(dataDir, String.valueOf(resourceId));
        if (!file.exists()) {
            log.error((Object)("File " + file.getAbsolutePath() + " does not exist"));
            return new Configuration();
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            Configuration config = (Configuration)ois.readObject();
            ois.close();
            fis.close();
            return config;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return new Configuration();
    }

    private static class CountTime {
        private long count = 0L;
        private long time = 0L;

        private CountTime() {
        }

        private void add(long count, long time) {
            this.count += count;
            this.time += time;
        }

        public String toString() {
            return "CountTime{count=" + this.count + ", time=" + this.time + '}';
        }
    }
}

