/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.content;

import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.server.content.ContentDiscoveryReport;
import org.rhq.core.pc.content.ContentManager;
import org.rhq.core.pc.content.ScheduledContentDiscoveryInfo;

public class ContentDiscoveryRunner
implements Runnable,
Callable<ContentDiscoveryReport> {
    private static final Log LOG = LogFactory.getLog(ContentDiscoveryRunner.class);
    private ScheduledContentDiscoveryInfo discoveryInfo;
    private boolean oneTimeDiscovery;
    private ContentManager contentManager;

    public ContentDiscoveryRunner(ContentManager contentManager) {
        this.contentManager = contentManager;
        this.discoveryInfo = null;
        this.oneTimeDiscovery = false;
    }

    public ContentDiscoveryRunner(ContentManager contentManager, ScheduledContentDiscoveryInfo discoveryInfo) {
        this.contentManager = contentManager;
        this.discoveryInfo = discoveryInfo;
        this.oneTimeDiscovery = true;
    }

    @Override
    public void run() {
        try {
            this.call();
        }
        catch (Exception e) {
            LOG.error((Object)"Content discovery runner failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentDiscoveryReport call() throws Exception {
        ScheduledContentDiscoveryInfo info = this.discoveryInfo;
        if (info == null) {
            info = this.contentManager.getNextScheduledDiscovery();
            if (info == null) {
                return null;
            }
            if (System.currentTimeMillis() - 120000L > info.getNextDiscovery()) {
                LOG.debug((Object)("Content discovery is falling behind. Missed discovery for " + info + " by: " + (System.currentTimeMillis() - info.getNextDiscovery()) + "ms"));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Performing discovery: " + info));
        }
        ContentDiscoveryReport result = null;
        try {
            result = this.contentManager.performContentDiscovery(info.getResourceId(), info.getPackageType());
        }
        catch (Throwable throwable) {
            LOG.warn((Object)"Exception received from component while attempting content retrieval", throwable);
        }
        finally {
            if (!this.oneTimeDiscovery) {
                this.contentManager.rescheduleDiscovery(info);
            }
        }
        return result;
    }
}

