/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.drift;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.common.drift.ChangeSetWriter;
import org.rhq.common.drift.FileEntry;
import org.rhq.common.drift.Headers;
import org.rhq.core.clientapi.agent.drift.DriftAgentService;
import org.rhq.core.clientapi.server.drift.DriftServerService;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.drift.Drift;
import org.rhq.core.domain.drift.DriftChangeSetCategory;
import org.rhq.core.domain.drift.DriftComplianceStatus;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftFile;
import org.rhq.core.domain.drift.DriftSnapshot;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.pc.ContainerService;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.agent.AgentService;
import org.rhq.core.pc.agent.AgentServiceStreamRemoter;
import org.rhq.core.pc.drift.ChangeSetManager;
import org.rhq.core.pc.drift.ChangeSetManagerImpl;
import org.rhq.core.pc.drift.DriftClient;
import org.rhq.core.pc.drift.DriftDetectionException;
import org.rhq.core.pc.drift.DriftDetectionSchedule;
import org.rhq.core.pc.drift.DriftDetectionSummary;
import org.rhq.core.pc.drift.DriftDetector;
import org.rhq.core.pc.drift.DriftFilesSender;
import org.rhq.core.pc.drift.ScheduleQueue;
import org.rhq.core.pc.drift.ScheduleQueueImpl;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.stream.StreamUtil;

public class DriftManager
extends AgentService
implements DriftAgentService,
DriftClient,
ContainerService {
    private static final Log log = LogFactory.getLog(DriftManager.class);
    private final PluginContainerConfiguration pluginContainerConfiguration;
    private final File changeSetsDir;
    private final ScheduledThreadPoolExecutor driftThreadPool;
    private final ScheduleQueue schedulesQueue = new ScheduleQueueImpl();
    private ChangeSetManager changeSetMgr;
    private final boolean initialized;
    private final InventoryManager inventoryManager;

    public DriftManager(PluginContainerConfiguration configuration, AgentServiceStreamRemoter streamRemoter, InventoryManager inventoryManager) {
        super(DriftAgentService.class, streamRemoter);
        boolean success;
        this.inventoryManager = inventoryManager;
        this.pluginContainerConfiguration = configuration;
        this.changeSetsDir = new File(this.pluginContainerConfiguration.getDataDirectory(), "changesets");
        long initStartTime = System.currentTimeMillis();
        if (!this.changeSetsDir.isDirectory() && !(success = this.changeSetsDir.mkdir())) {
            log.warn((Object)("Could not create change sets directory " + this.changeSetsDir));
            this.initialized = false;
            this.driftThreadPool = null;
            this.changeSetMgr = null;
            return;
        }
        this.changeSetMgr = new ChangeSetManagerImpl(this.changeSetsDir);
        DriftDetector driftDetector = new DriftDetector(this.schedulesQueue, this.changeSetMgr, this);
        long startTime = System.currentTimeMillis();
        this.initSchedules(inventoryManager.getPlatform(), inventoryManager);
        long endTime = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info((Object)("Finished initializing drift detection schedules in " + (endTime - startTime) + " ms"));
        }
        this.scanForContentToResend();
        this.purgeDeletedDriftDefDirs();
        this.driftThreadPool = new ScheduledThreadPoolExecutor(5);
        long initialDelay = this.pluginContainerConfiguration.getDriftDetectionInitialDelay();
        long period = this.pluginContainerConfiguration.getDriftDetectionPeriod();
        if (period > 0L) {
            this.driftThreadPool.scheduleAtFixedRate(driftDetector, initialDelay, period, TimeUnit.SECONDS);
        } else {
            log.info((Object)"Drift detection has been globally disabled as per plugin container configuration");
        }
        this.initialized = true;
        long initEndTime = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info((Object)("Finished initialization in " + (initEndTime - initStartTime) + " ms"));
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void initSchedules(Resource r, InventoryManager inventoryMgr) {
        if (r.getId() == 0) {
            log.debug((Object)("Will not reschedule drift detection for " + r + ". It is not sync'ed yet."));
            return;
        }
        ResourceContainer container = inventoryMgr.getResourceContainer(r.getId());
        if (container == null) {
            log.debug((Object)("No resource container found for " + r + ". Unable to reschedule drift detection schedules."));
            return;
        }
        log.debug((Object)("Rescheduling drift detection for " + r));
        for (DriftDefinition d : container.getDriftDefinitions()) {
            try {
                this.syncWithServer(r, d);
                this.schedulesQueue.addSchedule(new DriftDetectionSchedule(r.getId(), d));
            }
            catch (Throwable t) {
                log.error((Object)("Failed to sync with server for " + this.toString(r.getId(), d) + ". Drift detection will not be " + "scheduled."), t);
            }
        }
        for (Resource child : inventoryMgr.getContainerChildren(r, container)) {
            this.initSchedules(child, inventoryMgr);
        }
    }

    private void syncWithServer(Resource resource, DriftDefinition driftDefinition) throws IOException {
        Headers headers = this.createHeaders(resource.getId(), driftDefinition);
        if (!this.changeSetMgr.changeSetExists(resource.getId(), headers)) {
            log.info((Object)("No snapshot found for " + this.toString(resource.getId(), driftDefinition) + ". Downloading snapshot from server"));
            DriftServerService driftServer = this.pluginContainerConfiguration.getServerServices().getDriftServerService();
            DriftSnapshot snapshot = driftServer.getCurrentSnapshot(driftDefinition.getId());
            if (snapshot.getVersion() == -1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The server does not have any change sets for " + this.toString(resource.getId(), driftDefinition) + ". An initial snapshot needs to be generated."));
                }
                return;
            }
            headers.setVersion(snapshot.getVersion());
            log.info((Object)("Preparing to write snapshot at version " + snapshot.getVersion() + " to disk for " + this.toString(resource.getId(), driftDefinition)));
            File currentSnapshotFile = this.changeSetMgr.findChangeSet(resource.getId(), driftDefinition.getName(), DriftChangeSetCategory.COVERAGE);
            this.writeSnapshotToFile(snapshot, currentSnapshotFile, headers);
            if (driftDefinition.isPinned()) {
                log.debug((Object)(driftDefinition + " is pinned. Fetching pinned snapshot..."));
                DriftSnapshot pinnedSnapshot = driftServer.getSnapshot(driftDefinition.getId(), 0, 0);
                Headers pinnedHeaders = this.createHeaders(resource.getId(), driftDefinition);
                File pinnedSnapshotFile = new File(currentSnapshotFile.getParent(), "snapshot.pinned");
                log.info((Object)("Preparing to write pinned snapshot to disk for " + this.toString(resource.getId(), driftDefinition)));
                this.writeSnapshotToFile(pinnedSnapshot, pinnedSnapshotFile, pinnedHeaders);
                if (snapshot.getVersion() > 0) {
                    DriftSnapshot deltaSnapshot = driftServer.getSnapshot(driftDefinition.getId(), snapshot.getVersion(), snapshot.getVersion());
                    File deltaFile = new File(currentSnapshotFile.getParentFile(), "drift-changeset.txt");
                    Headers deltaHeaders = this.createHeaders(resource.getId(), driftDefinition);
                    deltaHeaders.setVersion(snapshot.getVersion());
                    deltaHeaders.setType(DriftChangeSetCategory.DRIFT);
                    this.writeSnapshotToFile(deltaSnapshot, deltaFile, deltaHeaders);
                }
            }
        }
    }

    private void purgeDeletedDriftDefDirs() {
        log.info((Object)"Checking for deleted drift definitions");
        for (File resourceDir : this.changeSetsDir.listFiles()) {
            int resourceId = Integer.parseInt(resourceDir.getName());
            for (File defDir : resourceDir.listFiles()) {
                DriftDefinition driftDef = new DriftDefinition(new Configuration());
                driftDef.setName(defDir.getName());
                if (this.schedulesQueue.contains(resourceId, driftDef)) continue;
                log.info((Object)("Detected deleted drift definition, DriftDefinition[name: " + driftDef.getName() + ", resourceId: " + resourceId + "]"));
                log.info((Object)("Deleting drift definition directory " + defDir.getPath()));
                FileUtil.purge((File)defDir, (boolean)true);
            }
        }
    }

    public void scanForContentToResend() {
        log.info((Object)"Scanning for change set content to resend...");
        File[] files = this.changeSetsDir.listFiles();
        if (files == null) {
            return;
        }
        for (File resourceDir : files) {
            for (File defDir : resourceDir.listFiles()) {
                for (File contentZipFile : defDir.listFiles(new ZipFileNameFilter("content_"))) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Resending " + contentZipFile.getPath()));
                    }
                    this.sendChangeSetContentToServer(Integer.parseInt(resourceDir.getName()), defDir.getName(), contentZipFile);
                }
            }
        }
    }

    void setChangeSetMgr(ChangeSetManager changeSetMgr) {
        this.changeSetMgr = changeSetMgr;
    }

    public ScheduleQueue getSchedulesQueue() {
        return this.schedulesQueue;
    }

    @Override
    public void shutdown() {
        if (this.driftThreadPool != null) {
            PluginContainer.shutdownExecutorService(this.driftThreadPool, false);
        }
        this.schedulesQueue.clear();
        this.changeSetMgr = null;
    }

    @Override
    public void sendChangeSetToServer(DriftDetectionSummary detectionSummary) {
        DriftDefinition driftDefinition;
        int resourceId = detectionSummary.getSchedule().getResourceId();
        if (!this.schedulesQueue.contains(resourceId, driftDefinition = detectionSummary.getSchedule().getDriftDefinition())) {
            return;
        }
        File changeSetFile = detectionSummary.getType() == DriftChangeSetCategory.COVERAGE ? detectionSummary.getNewSnapshot() : detectionSummary.getDriftChangeSet();
        if (changeSetFile == null) {
            log.warn((Object)("changeset[resourceId: " + resourceId + ", driftDefinition: " + driftDefinition.getName() + "] was not found. Cancelling request to send change set " + "to server"));
            return;
        }
        DriftServerService driftServer = this.pluginContainerConfiguration.getServerServices().getDriftServerService();
        String fileName = "changeset_" + System.currentTimeMillis() + ".zip";
        File zipFile = new File(changeSetFile.getParentFile(), fileName);
        try {
            ZipOutputStream stream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
            FileInputStream fis = new FileInputStream(changeSetFile);
            stream.putNextEntry(new ZipEntry(changeSetFile.getName()));
            StreamUtil.copy((InputStream)fis, (OutputStream)stream, (boolean)true);
        }
        catch (IOException e) {
            zipFile.delete();
            throw new DriftDetectionException("Failed to create change set zip file " + zipFile.getPath(), e);
        }
        try {
            driftServer.sendChangesetZip(resourceId, zipFile.length(), this.remoteInputStream(new BufferedInputStream(new FileInputStream(zipFile))));
        }
        catch (IOException e) {
            throw new DriftDetectionException("Failed to set change set for " + this.toString(resourceId, driftDefinition) + " to server");
        }
        catch (RuntimeException e) {
            throw new DriftDetectionException("Failed to set change set for " + this.toString(resourceId, driftDefinition) + " to server");
        }
    }

    @Override
    public void sendChangeSetContentToServer(int resourceId, String driftDefName, File contentZipFile) {
        try {
            int startIndex = "content_".length();
            int endIndex = contentZipFile.getName().indexOf(".");
            String token = contentZipFile.getName().substring(startIndex, endIndex);
            DriftServerService driftServer = this.pluginContainerConfiguration.getServerServices().getDriftServerService();
            driftServer.sendFilesZip(resourceId, driftDefName, token, contentZipFile.length(), this.remoteInputStream(new BufferedInputStream(new FileInputStream(contentZipFile))));
        }
        catch (FileNotFoundException e) {
            log.error((Object)("An error occurred while trying to send change set content zip file " + contentZipFile.getPath() + " to server."), (Throwable)e);
        }
    }

    @Override
    public void repeatChangeSet(int resourceId, String driftDefName, int version) {
        DriftServerService driftServer = this.pluginContainerConfiguration.getServerServices().getDriftServerService();
        driftServer.repeatChangeSet(resourceId, driftDefName, version);
    }

    public void detectDrift(int resourceId, DriftDefinition driftDefinition) {
        DriftDetectionSchedule schedule;
        if (log.isInfoEnabled()) {
            log.info((Object)("Received request to schedule drift detection immediately for [resourceId: " + resourceId + ", driftDefinitionId: " + driftDefinition.getId() + ", driftDefinitionName: " + driftDefinition.getName() + "]"));
        }
        if ((schedule = this.schedulesQueue.remove(resourceId, driftDefinition)) == null) {
            log.warn((Object)("No schedule found in the queue for [resourceId: " + resourceId + ", driftDefinitionId: " + driftDefinition.getId() + ", driftDefinitionName: " + driftDefinition.getName() + "]. No " + " work will be scheduled."));
            return;
        }
        log.debug((Object)("Resetting " + schedule + " for immediate detection."));
        schedule.resetSchedule();
        boolean queueUpdated = this.schedulesQueue.addSchedule(schedule);
        if (queueUpdated) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(schedule + " has been added to " + this.schedulesQueue + " for immediate detection."));
            }
        } else {
            log.warn((Object)("Failed to add " + schedule + " to " + this.schedulesQueue + " for immediate detection."));
        }
    }

    public void scheduleDriftDetection(int resourceId, DriftDefinition driftDefinition) {
        boolean added;
        DriftDetectionSchedule schedule = new DriftDetectionSchedule(resourceId, driftDefinition);
        if (log.isInfoEnabled()) {
            log.info((Object)("Scheduling drift detection for " + schedule));
        }
        if (added = this.schedulesQueue.addSchedule(schedule)) {
            ResourceContainer container;
            if (log.isDebugEnabled()) {
                log.debug((Object)(schedule + " has been added to " + this.schedulesQueue));
            }
            if ((container = this.inventoryManager.getResourceContainer(resourceId)) != null) {
                container.addDriftDefinition(driftDefinition);
            }
        } else {
            log.warn((Object)("Failed to add " + schedule + " to " + this.schedulesQueue));
        }
    }

    public boolean requestDriftFiles(int resourceId, Headers headers, List<? extends DriftFile> driftFiles) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Server is requesting files for [resourceId: " + resourceId + ", driftDefinitionId: " + headers.getDriftDefinitionId() + ", driftDefinitionName: " + headers.getDriftDefinitionName() + "]"));
        }
        DriftFilesSender sender = new DriftFilesSender();
        sender.setResourceId(resourceId);
        sender.setDriftClient(this);
        sender.setDriftFiles(driftFiles);
        sender.setHeaders(headers);
        sender.setChangeSetManager(this.changeSetMgr);
        this.driftThreadPool.execute(sender);
        return true;
    }

    public void unscheduleDriftDetection(final int resourceId, final DriftDefinition driftDefinition) {
        ResourceContainer container;
        log.info((Object)("Received request to unschedule drift detection for [resourceId:" + resourceId + ", driftDefinitionId: " + driftDefinition.getId() + ", driftDefinitionName: " + driftDefinition.getName() + "]."));
        DriftDetectionSchedule schedule = this.schedulesQueue.removeAndExecute(resourceId, driftDefinition, new Runnable(){

            @Override
            public void run() {
                File resourceDir = new File(DriftManager.this.changeSetsDir, Integer.toString(resourceId));
                File changeSetDir = new File(resourceDir, driftDefinition.getName());
                FileUtil.purge((File)changeSetDir, (boolean)true);
                log.debug((Object)("Removed change set directory " + changeSetDir.getAbsolutePath()));
            }
        });
        if (schedule != null && (container = this.inventoryManager.getResourceContainer(resourceId)) != null) {
            container.removeDriftDefinition(schedule.getDriftDefinition());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removed " + schedule + " from the queue " + this.schedulesQueue));
        }
    }

    public void updateDriftDetection(int resourceId, DriftDefinition driftDefinition) {
        log.info((Object)("Received request to update schedule for " + this.toString(resourceId, driftDefinition)));
        DriftDetectionSchedule updatedSchedule = this.schedulesQueue.update(resourceId, driftDefinition);
        if (updatedSchedule == null) {
            boolean added;
            updatedSchedule = new DriftDetectionSchedule(resourceId, driftDefinition);
            if (log.isInfoEnabled()) {
                log.info((Object)("No matching schedule was found in the queue. This must be a request to add a new schedule. Adding " + updatedSchedule + " to " + this.schedulesQueue));
            }
            if (added = this.schedulesQueue.addSchedule(updatedSchedule)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(updatedSchedule + " has been added to " + this.schedulesQueue));
                }
            } else {
                log.warn((Object)("Failed to add " + updatedSchedule + " to " + this.schedulesQueue));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)(updatedSchedule + " has been updated and added back to " + this.schedulesQueue));
            } else if (log.isInfoEnabled()) {
                log.info((Object)(updatedSchedule + " has been updated."));
            }
            if (!updatedSchedule.getDriftDefinition().isPinned()) {
                this.unpinDefinition(updatedSchedule);
            }
        }
        InventoryManager inventoryMgr = PluginContainer.getInstance().getInventoryManager();
        ResourceContainer container = inventoryMgr.getResourceContainer(resourceId);
        if (container != null) {
            container.addDriftDefinition(driftDefinition);
        }
    }

    private void unpinDefinition(final DriftDetectionSchedule schedule) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unpinning definition for " + this.toString(schedule.getResourceId(), schedule.getDriftDefinition())));
        }
        this.schedulesQueue.removeAndExecute(schedule.getResourceId(), schedule.getDriftDefinition(), new Runnable(){

            @Override
            public void run() {
                File currentSnapshot = DriftManager.this.changeSetMgr.findChangeSet(schedule.getResourceId(), schedule.getDriftDefinition().getName(), DriftChangeSetCategory.COVERAGE);
                File pinnedSnapshot = new File(currentSnapshot.getParentFile(), "snapshot.pinned");
                pinnedSnapshot.delete();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleted pinned snapshot file " + pinnedSnapshot.getPath()));
                }
                DriftManager.this.schedulesQueue.addSchedule(schedule);
            }
        });
    }

    public void updateDriftDetection(int resourceId, DriftDefinition driftDef, DriftSnapshot driftSnapshot) {
        File currentSnapshot = this.changeSetMgr.findChangeSet(resourceId, driftDef.getName(), DriftChangeSetCategory.COVERAGE);
        File pinnedSnapshot = new File(currentSnapshot.getParentFile(), "snapshot.pinned");
        Headers headers = this.createHeaders(resourceId, driftDef);
        try {
            this.writeSnapshotToFile(driftSnapshot, currentSnapshot, headers);
        }
        catch (IOException e) {
            log.error((Object)("An error occurred while writing snapshot file [" + currentSnapshot.getPath() + "] to disk"), (Throwable)e);
            currentSnapshot.delete();
            return;
        }
        try {
            StreamUtil.copy((InputStream)new BufferedInputStream(new FileInputStream(currentSnapshot)), (OutputStream)new BufferedOutputStream(new FileOutputStream(pinnedSnapshot)), (boolean)true);
        }
        catch (IOException e) {
            log.error((Object)("An error occurred while writing snapshot file [" + pinnedSnapshot.getPath() + "] to disk"), (Throwable)e);
            currentSnapshot.delete();
            pinnedSnapshot.delete();
            return;
        }
        this.updateDriftDetection(resourceId, driftDef);
    }

    @Override
    public void reportMissingBaseDir(int resourceId, DriftDefinition driftDefinition) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reporting to server missing base directory for " + this.toString(resourceId, driftDefinition)));
        }
        DriftServerService driftServer = this.pluginContainerConfiguration.getServerServices().getDriftServerService();
        driftServer.updateCompliance(resourceId, driftDefinition.getName(), DriftComplianceStatus.OUT_OF_COMPLIANCE_NO_BASEDIR);
    }

    public void pinSnapshot(int resourceId, String defName, DriftSnapshot snapshot) {
        DriftDetectionSchedule schedule;
        if (log.isInfoEnabled()) {
            log.info((Object)("Pinning snapshot for " + this.toString(resourceId, defName)));
        }
        if ((schedule = this.schedulesQueue.find(resourceId, defName)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to pin snapshot for " + this.toString(resourceId, defName) + " - no detection schedule " + "found."));
            }
            return;
        }
        DriftDefinition driftDef = schedule.getDriftDefinition();
        driftDef.setPinned(true);
        this.unscheduleDriftDetection(resourceId, driftDef);
        this.updateDriftDetection(resourceId, driftDef, snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ackChangeSet(int resourceId, String defName) {
        log.info((Object)("Received server change set ack for [resourceId: " + resourceId + ", driftDefinition:" + defName + "]"));
        File resourceDir = new File(this.changeSetsDir, Integer.toString(resourceId));
        File changeSetDir = new File(resourceDir, defName);
        if (!changeSetDir.exists()) {
            log.warn((Object)("Cannot complete acknowledgement. Change set directory " + changeSetDir.getPath() + " does not exist."));
            return;
        }
        try {
            File snapshot = this.changeSetMgr.findChangeSet(resourceId, defName, DriftChangeSetCategory.COVERAGE);
            if (null == snapshot) {
                log.warn((Object)("Cannot complete acknowledgement. Could not find coverage changeset for [" + resourceId + "," + defName + "]."));
                return;
            }
            File previousSnapshot = new File(snapshot.getParentFile(), snapshot.getName() + ".previous");
            previousSnapshot.delete();
        }
        finally {
            this.deleteZipFiles(changeSetDir, "changeset_");
        }
    }

    public void ackChangeSetContent(int resourceId, String driftDefName, String token) {
        log.info((Object)("Received server change set content ack for [resourceId: " + resourceId + ", driftDefinitionName: " + driftDefName + "]"));
        File resourceDir = new File(this.changeSetsDir, Integer.toString(resourceId));
        File changeSetDir = new File(resourceDir, driftDefName);
        if (!changeSetDir.exists()) {
            log.warn((Object)("Cannot complete acknowledgement. Change set directory " + changeSetDir.getPath() + " does not exist."));
            return;
        }
        this.deleteZipFiles(changeSetDir, "content_" + token);
    }

    private void deleteZipFiles(File dir, String prefix) {
        for (File file : dir.listFiles(new ZipFileNameFilter(prefix))) {
            file.delete();
        }
    }

    @Override
    public File getAbsoluteBaseDirectory(int resourceId, DriftDefinition driftDefinition) {
        File destDir;
        String baseLocation;
        ResourceContainer container = this.inventoryManager.getResourceContainer(resourceId);
        if (container == null) {
            log.error((Object)("Cannot determine base directory for " + driftDefinition + ". No resource container found " + "for resource id " + resourceId + ". You may want to restart the agent with the -u option so that " + "the agent's local inventory is synchronized with and consistent with the server's inventory."));
            throw new IllegalArgumentException("Cannot determine base directory for " + driftDefinition + ". No resource container found for resource id " + resourceId);
        }
        Resource resource = container.getResource();
        DriftDefinition.BaseDirectory baseDir = driftDefinition.getBasedir();
        if (baseDir == null) {
            throw new IllegalArgumentException("Base directory is null for drift definition [" + driftDefinition.getName() + "]");
        }
        String baseDirValueName = baseDir.getValueName();
        switch (baseDir.getValueContext()) {
            case fileSystem: {
                baseLocation = baseDirValueName;
                if (baseLocation != null && baseLocation.trim().length() != 0) break;
                baseLocation = File.separator;
                break;
            }
            case pluginConfiguration: {
                baseLocation = resource.getPluginConfiguration().getSimpleValue(baseDirValueName, null);
                if (baseLocation != null) break;
                throw new IllegalArgumentException("Cannot determine the base directory - there is no plugin configuration setting for [" + baseDirValueName + "]");
            }
            case resourceConfiguration: {
                baseLocation = InventoryManager.getResourceConfiguration(resource).getSimpleValue(baseDirValueName, null);
                if (baseLocation != null) break;
                throw new IllegalArgumentException("Cannot determine the base directory - there is no resource configuration setting for [" + baseDirValueName + "]");
            }
            case measurementTrait: {
                baseLocation = this.getTraitValue(container, baseDirValueName);
                if (baseLocation != null) break;
                throw new IllegalArgumentException("Cannot obtain trait [" + baseDirValueName + "] for resource [" + resource.getName() + "]");
            }
            default: {
                throw new IllegalArgumentException("Unknown location context: " + baseDir.getValueContext());
            }
        }
        if (!(destDir = new File(baseLocation)).isAbsolute()) {
            throw new IllegalArgumentException("The base location path specified by [" + baseDirValueName + "] in the context [" + baseDir.getValueContext() + "] did not resolve to an absolute path [" + destDir.getPath() + "] so there is no way to know what directory to monitor for drift");
        }
        return destDir;
    }

    private String getTraitValue(ResourceContainer container, String traitName) {
        return this.inventoryManager.getMeasurementManager().getTraitValue(container, traitName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSnapshotToFile(DriftSnapshot snapshot, File file, Headers headers) throws IOException {
        ChangeSetWriter writer = this.changeSetMgr.getChangeSetWriter(file, headers);
        try {
            block7: for (Drift drift : snapshot.getDriftInstances()) {
                switch (drift.getCategory()) {
                    case FILE_ADDED: {
                        writer.write(FileEntry.addedFileEntry((String)drift.getPath(), (String)drift.getNewDriftFile().getHashId(), (Long)-1L, (Long)-1L));
                        continue block7;
                    }
                    case FILE_CHANGED: {
                        writer.write(FileEntry.changedFileEntry((String)drift.getPath(), (String)drift.getOldDriftFile().getHashId(), (String)drift.getNewDriftFile().getHashId(), (Long)-1L, (Long)-1L));
                        continue block7;
                    }
                }
                writer.write(FileEntry.removedFileEntry((String)drift.getPath(), (String)drift.getOldDriftFile().getHashId()));
            }
        }
        finally {
            writer.close();
        }
    }

    private String toString(int resourceId, DriftDefinition d) {
        return "DriftDefinition[id: " + d.getId() + ", name: " + d.getName() + ", resourceId: " + resourceId + "]";
    }

    private String toString(int resourceId, String defName) {
        return "[resourceId: " + resourceId + ", driftDefintionName: " + defName + "]";
    }

    private Headers createHeaders(int resourceId, DriftDefinition driftDef) {
        Headers headers = new Headers();
        headers.setResourceId(resourceId);
        headers.setDriftDefinitionId(driftDef.getId());
        headers.setType(DriftChangeSetCategory.COVERAGE);
        headers.setDriftDefinitionName(driftDef.getName());
        headers.setBasedir(this.getAbsoluteBaseDirectory(resourceId, driftDef).getAbsolutePath());
        return headers;
    }

    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    private static class ZipFileNameFilter
    implements FilenameFilter {
        private final String prefix;

        public ZipFileNameFilter(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(this.prefix) && name.endsWith(".zip");
        }
    }
}

