/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.drift;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.rhq.core.domain.drift.Filter;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.file.FileVisitor;
import org.rhq.core.util.file.PathFilter;

public class FilterFileVisitor
implements FileVisitor {
    private List<PathFilter> includes;
    private List<PathFilter> excludes;
    private FileVisitor visitor;
    private Pattern includesPattern;
    private Pattern excludesPattern;

    public FilterFileVisitor(File basedir, List<Filter> includes, List<Filter> excludes, FileVisitor visitor) {
        this.includes = this.convert(basedir, includes);
        this.excludes = this.convert(basedir, excludes);
        this.visitor = visitor;
        this.includesPattern = FileUtil.generateRegex(this.includes);
        this.excludesPattern = FileUtil.generateRegex(this.excludes);
    }

    private List<PathFilter> convert(File basedir, List<Filter> filters) {
        ArrayList<PathFilter> pathFilters = new ArrayList<PathFilter>(filters.size());
        for (Filter filter : filters) {
            pathFilters.add(this.normalize(basedir, filter));
        }
        return pathFilters;
    }

    private PathFilter normalize(File basedir, Filter filter) {
        File path = new File(filter.getPath());
        File filterPath = path.isAbsolute() ? path : new File(basedir, filter.getPath());
        String filterPattern = filterPath.isDirectory() && this.isEmpty(filter.getPattern()) ? "**/*" : filter.getPattern();
        return new PathFilter(FilenameUtils.normalize((String)filterPath.getAbsolutePath()), filterPattern);
    }

    private boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public void visit(File file) {
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            this.visitor.visit(file);
        } else if (!this.includes.isEmpty() && this.excludes.isEmpty()) {
            if (this.includesPattern.matcher(file.getAbsolutePath()).matches()) {
                this.visitor.visit(file);
            }
        } else if (this.includes.isEmpty() && !this.excludes.isEmpty()) {
            if (!this.excludesPattern.matcher(file.getAbsolutePath()).matches()) {
                this.visitor.visit(file);
            }
        } else if (this.includesPattern.matcher(file.getAbsolutePath()).matches() && !this.excludesPattern.matcher(file.getAbsolutePath()).matches()) {
            this.visitor.visit(file);
        }
    }
}

