/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.drift;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftDefinitionComparator;
import org.rhq.core.pc.drift.DriftDetectionSchedule;
import org.rhq.core.pc.drift.ScheduleQueue;

public class ScheduleQueueImpl
implements ScheduleQueue {
    private static final Runnable NO_OP = new Runnable(){

        @Override
        public void run() {
        }
    };
    private PriorityQueue<DriftDetectionSchedule> queue = new PriorityQueue();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private DriftDetectionSchedule activeSchedule;
    private Runnable deactivationTask;
    private Log log = LogFactory.getLog(ScheduleQueueImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DriftDetectionSchedule getNextSchedule() {
        try {
            this.lock.writeLock().lock();
            if (this.activeSchedule != null) {
                throw new IllegalStateException("There is already an active schedule that must be deactivated before getting the next schedule.");
            }
            this.activeSchedule = this.queue.poll();
            DriftDetectionSchedule driftDetectionSchedule = this.activeSchedule == null ? null : this.activeSchedule.copy();
            return driftDetectionSchedule;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean isActiveSchedule(int resourceId, DriftDefinition driftDef) {
        return this.isActiveSchedule(resourceId, driftDef.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isActiveSchedule(int resourceId, String defName) {
        try {
            this.lock.readLock().lock();
            boolean bl = this.activeSchedule != null && this.activeSchedule.getResourceId() == resourceId && this.activeSchedule.getDriftDefinition().getName().equals(defName);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isActiveSchedule(int resourceId, DriftDefinition driftDef, DriftDefinitionComparator comparator) {
        try {
            this.lock.readLock().lock();
            boolean bl = this.activeSchedule != null && this.activeSchedule.getResourceId() == resourceId && comparator.compare(this.activeSchedule.getDriftDefinition(), driftDef) == 0;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivateSchedule(boolean updateSchedule) {
        try {
            this.lock.writeLock().lock();
            if (this.deactivationTask != null) {
                this.deactivationTask.run();
            }
            if (this.activeSchedule == null) {
                return;
            }
            if (updateSchedule) {
                this.activeSchedule.updateShedule();
            }
            if (this.log.isDebugEnabled()) {
                SimpleDateFormat formatter = new SimpleDateFormat();
                formatter.applyPattern("hh:mm:ss:SSS a");
                this.log.debug((Object)("The next drift detection run for " + this.activeSchedule + " is set for " + formatter.format(new Date(this.activeSchedule.getNextScan()))));
            }
            this.queue.offer(this.activeSchedule);
            this.activeSchedule = null;
        }
        finally {
            this.deactivationTask = null;
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addSchedule(DriftDetectionSchedule schedule) {
        boolean inserted = false;
        try {
            this.lock.writeLock().lock();
            inserted = this.queue.offer(schedule);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return inserted;
    }

    @Override
    public boolean contains(int resourceId, DriftDefinition driftDef) {
        return this.find(resourceId, driftDef.getName()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(int resourceId, DriftDefinition driftDef, DriftDefinitionComparator comparator) {
        if (this.isActiveSchedule(resourceId, driftDef, comparator)) {
            return true;
        }
        try {
            this.lock.readLock().lock();
            for (DriftDetectionSchedule schedule : this.queue) {
                if (schedule.getResourceId() != resourceId || comparator.compare(schedule.getDriftDefinition(), driftDef) != 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DriftDetectionSchedule find(int resourceId, String defName) {
        if (this.isActiveSchedule(resourceId, defName)) {
            return this.activeSchedule.copy();
        }
        try {
            this.lock.readLock().lock();
            for (DriftDetectionSchedule schedule : this.queue) {
                if (schedule.getResourceId() != resourceId || !schedule.getDriftDefinition().getName().equals(defName)) continue;
                DriftDetectionSchedule driftDetectionSchedule = schedule.copy();
                return driftDetectionSchedule;
            }
            DriftDetectionSchedule driftDetectionSchedule = null;
            return driftDetectionSchedule;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public DriftDetectionSchedule remove(int resourceId, DriftDefinition driftDef) {
        return this.remove(resourceId, driftDef.getName());
    }

    @Override
    public DriftDetectionSchedule remove(int resourceId, String defName) {
        return this.removeAndExecute(resourceId, defName, NO_OP);
    }

    @Override
    public DriftDetectionSchedule removeAndExecute(int resourceId, DriftDefinition driftDef, Runnable task) {
        return this.removeAndExecute(resourceId, driftDef.getName(), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DriftDetectionSchedule removeAndExecute(int resourceId, String defName, Runnable task) {
        try {
            this.lock.writeLock().lock();
            if (this.isActiveSchedule(resourceId, defName)) {
                this.deactivationTask = task;
                DriftDetectionSchedule removedSchedule = this.activeSchedule;
                this.activeSchedule = null;
                DriftDetectionSchedule driftDetectionSchedule = removedSchedule;
                return driftDetectionSchedule;
            }
            Iterator<DriftDetectionSchedule> iterator = this.queue.iterator();
            while (iterator.hasNext()) {
                DriftDetectionSchedule schedule = iterator.next();
                if (schedule.getResourceId() != resourceId || !schedule.getDriftDefinition().getName().equals(defName)) continue;
                iterator.remove();
                task.run();
                DriftDetectionSchedule driftDetectionSchedule = schedule;
                return driftDetectionSchedule;
            }
            DriftDetectionSchedule driftDetectionSchedule = null;
            return driftDetectionSchedule;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DriftDetectionSchedule update(int resourceId, DriftDefinition driftDef) {
        DriftDetectionSchedule schedule = this.remove(resourceId, driftDef);
        if (schedule == null) {
            return null;
        }
        this.update(schedule, driftDef);
        try {
            this.lock.writeLock().lock();
            if (this.queue.offer(schedule)) {
                DriftDetectionSchedule driftDetectionSchedule = schedule.copy();
                return driftDetectionSchedule;
            }
            DriftDetectionSchedule driftDetectionSchedule = null;
            return driftDetectionSchedule;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void update(DriftDetectionSchedule schedule, DriftDefinition driftDef) {
        schedule.getDriftDefinition().setEnabled(Boolean.valueOf(driftDef.isEnabled()));
        schedule.getDriftDefinition().setInterval(Long.valueOf(driftDef.getInterval()));
        schedule.getDriftDefinition().setDriftHandlingMode(driftDef.getDriftHandlingMode());
        schedule.getDriftDefinition().setPinned(driftDef.isPinned());
        schedule.getDriftDefinition().setComplianceStatus(driftDef.getComplianceStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try {
            this.lock.writeLock().lock();
            this.activeSchedule = null;
            this.queue.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        try {
            this.lock.readLock().lock();
            if (this.activeSchedule == null && this.queue.isEmpty()) {
                String string = "ScheduleQueue[]";
                return string;
            }
            Object[] schedules = this.toArray();
            Arrays.sort(schedules);
            ArrayList<Object> list = new ArrayList<Object>(schedules.length + 1);
            if (this.activeSchedule != null) {
                list.add(this.activeSchedule);
            }
            list.addAll(Arrays.asList(schedules));
            StringBuilder buffer = new StringBuilder("ScheduleQueue[");
            for (DriftDetectionSchedule string : list) {
                buffer.append(string).append(", ");
            }
            int end = buffer.length();
            buffer.delete(end - 2, end);
            buffer.append("]");
            String string = buffer.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DriftDetectionSchedule[] toArray() {
        try {
            this.lock.readLock().lock();
            DriftDetectionSchedule[] driftDetectionScheduleArray = this.queue.toArray(new DriftDetectionSchedule[this.queue.size()]);
            return driftDetectionScheduleArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

