/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.drift;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pc.drift.SnapshotHandle;
import org.rhq.core.util.MessageDigestGenerator;

public class SnapshotGenerator
extends DirectoryWalker {
    private final Log log = LogFactory.getLog(SnapshotGenerator.class);
    private MessageDigestGenerator digestGenerator = new MessageDigestGenerator("SHA-256");
    private File snapshotDir;

    public void setSnapshotDir(File dir) {
        this.snapshotDir = dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnapshotHandle generateSnapshot(int resourceId, File basedir) throws IOException {
        ArrayList files = new ArrayList();
        this.walk(basedir, files);
        File metadatFile = new File(this.snapshotDir, resourceId + "_snapshot_metadata.txt");
        PrintWriter metadataWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(metadatFile)));
        File zipFile = new File(this.snapshotDir, resourceId + "-snapshot" + ".zip");
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
            for (File file : files) {
                String relativePath = this.relativePath(basedir, file);
                metadataWriter.println(relativePath + " " + this.sha256(file));
                InputStream istream = null;
                try {
                    istream = new BufferedInputStream(new FileInputStream(new File(basedir.getParent(), relativePath)));
                    ZipEntry entry = new ZipEntry(relativePath);
                    zos.putNextEntry(entry);
                    IOUtils.copy((InputStream)istream, (OutputStream)zos);
                }
                catch (IOException e) {
                    this.log.error((Object)("Failed to add file " + file + " to zipfile " + zipFile + "."), (Throwable)e);
                }
                finally {
                    if (istream == null) continue;
                    istream.close();
                }
            }
        }
        finally {
            if (metadataWriter != null) {
                metadataWriter.close();
            }
            if (zos != null) {
                zos.close();
            }
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)new FileInputStream(zipFile), (OutputStream)byteStream);
        return new SnapshotHandle(zipFile, metadatFile);
    }

    private String relativePath(File basedir, File file) {
        return FilenameUtils.getName((String)basedir.getAbsolutePath()) + File.separator + file.getAbsolutePath().substring(basedir.getAbsolutePath().length() + 1);
    }

    private String sha256(File file) throws IOException {
        return this.digestGenerator.calcDigestString(file);
    }

    protected boolean handleDirectory(File directory, int depth, Collection results) throws IOException {
        return true;
    }

    protected void handleFile(File file, int depth, Collection results) throws IOException {
        results.add(file);
    }
}

