/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.event;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.pc.event.EventManager;
import org.rhq.core.pluginapi.event.EventPoller;

public class EventPollerRunner
implements Runnable {
    private static final Log LOG = LogFactory.getLog(EventPollerRunner.class);
    private EventPoller eventPoller;
    private Resource resource;
    private EventManager eventManager;

    public EventPollerRunner(EventPoller eventPoller, Resource resource, EventManager eventManager) {
        this.eventPoller = eventPoller;
        this.resource = resource;
        this.eventManager = eventManager;
    }

    @Override
    public void run() {
        try {
            Set events = this.eventPoller.poll();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Gathered " + (events == null ? "no" : Integer.valueOf(events.size())) + " events on resource " + this.resource + " using the poller " + this.eventPoller));
            }
            if (events != null) {
                this.eventManager.publishEvents(events, this.resource);
            }
        }
        catch (RuntimeException e) {
            LOG.error((Object)("Event poller for resource " + this.resource + " failed with a unhandled exception. No future events will be reported for the resource until the plugin container is restarted. " + "This is an error and should not have happened. Please report this as a bug."), (Throwable)e);
            throw e;
        }
    }
}

