/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.inventory;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.metadata.ResourceTypeNotEnabledException;
import org.rhq.core.clientapi.server.discovery.AutoDiscoveryRequest;
import org.rhq.core.clientapi.server.discovery.InventoryReport;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.ProcessScan;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.state.discovery.AutoDiscoveryScanType;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.plugin.PluginComponentFactory;
import org.rhq.core.pc.plugin.PluginManager;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.system.pquery.ProcessInfoQuery;
import org.rhq.core.util.exception.ExceptionPackage;
import org.rhq.core.util.exception.Severity;

public class AutoDiscoveryExecutor
implements Runnable,
Callable<InventoryReport> {
    private static final Log log = LogFactory.getLog(AutoDiscoveryExecutor.class);
    private final AutoDiscoveryRequest autoDiscoveryRequest;
    private final InventoryManager inventoryManager;

    public AutoDiscoveryExecutor(AutoDiscoveryRequest autoDiscoveryRequest, InventoryManager inventoryManager) {
        this.autoDiscoveryRequest = autoDiscoveryRequest;
        this.inventoryManager = inventoryManager;
    }

    @Override
    public void run() {
        this.call();
    }

    @Override
    @NotNull
    public InventoryReport call() {
        log.info((Object)"Executing server discovery scan...");
        InventoryReport report = new InventoryReport(this.inventoryManager.getAgent());
        try {
            report.setStartTime(System.currentTimeMillis());
            if (this.autoDiscoveryRequest == null || this.autoDiscoveryRequest.getScanTypes().contains(AutoDiscoveryScanType.Plugin)) {
                List<ProcessInfo> processInfos = this.getProcessInfos();
                this.pluginDiscovery(report, processInfos);
            }
            report.setEndTime(System.currentTimeMillis());
            if (report.getAddedRoots().size() == 1 && ((Resource)report.getAddedRoots().iterator().next()).getResourceType().getCategory() == ResourceCategory.PLATFORM) {
                Resource platform = (Resource)report.getAddedRoots().iterator().next();
                log.info((Object)("Discovered new platform with " + platform.getChildResources().size() + " child server(s)."));
            } else {
                log.info((Object)("Discovered " + report.getAddedRoots().size() + " new server(s)."));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Server discovery scan took [" + (report.getEndTime() - report.getStartTime()) + "] ms."));
            }
            if (log.isTraceEnabled()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(report);
                log.trace((Object)("Server Discovery report for [" + report.getResourceCount() + "] resources with a size of [" + baos.size() + "] bytes"));
            }
            this.inventoryManager.handleReport(report);
        }
        catch (Exception e) {
            log.warn((Object)"Exception caught while executing server discovery scan.", (Throwable)e);
            report.addError(new ExceptionPackage(Severity.Warning, (Throwable)e));
        }
        return report;
    }

    private List<ProcessInfo> getProcessInfos() {
        SystemInfo systemInfo = SystemInfoFactory.createSystemInfo();
        log.debug((Object)"Retrieving process table...");
        long startTime = System.currentTimeMillis();
        List processInfos = null;
        try {
            processInfos = systemInfo.getAllProcesses();
        }
        catch (UnsupportedOperationException uoe) {
            log.debug((Object)("Cannot perform process scan - not supported on this platform. (" + systemInfo.getClass() + ")"));
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieval of process table took " + elapsedTime + " ms."));
        }
        return processInfos;
    }

    private void pluginDiscovery(InventoryReport report, List<ProcessInfo> processInfos) {
        this.inventoryManager.executePlatformScan();
        PluginManager pluginManager = this.inventoryManager.getPluginManager();
        PluginComponentFactory factory = this.inventoryManager.getPluginComponentFactory();
        Set serverTypes = pluginManager.getMetadataManager().getTypesForCategory(ResourceCategory.SERVER);
        ResourceContainer platformContainer = this.inventoryManager.getResourceContainer(this.inventoryManager.getPlatform());
        Resource platformResource = platformContainer.getResource();
        for (ResourceType serverType : serverTypes) {
            if (!serverType.getParentResourceTypes().isEmpty()) continue;
            try {
                ResourceDiscoveryComponent component = factory.getDiscoveryComponent(serverType, platformContainer);
                if (platformContainer.getSynchronizationState() == ResourceContainer.SynchronizationState.NEW) {
                    report.addAddedRoot(platformResource);
                }
                List<ProcessScanResult> scanResults = this.performProcessScans(processInfos, serverType);
                Set<Resource> discoveredServers = this.inventoryManager.executeComponentDiscovery(serverType, component, platformContainer, scanResults);
                for (Resource discoveredServer : discoveredServers) {
                    Resource inventoriedResource = this.inventoryManager.mergeResourceFromDiscovery(discoveredServer, platformResource);
                    if (inventoriedResource.getInventoryStatus() != InventoryStatus.NEW || platformContainer.getSynchronizationState() != ResourceContainer.SynchronizationState.SYNCHRONIZED) continue;
                    report.addAddedRoot(inventoriedResource);
                }
            }
            catch (ResourceTypeNotEnabledException rtne) {
            }
            catch (Throwable e) {
                report.getErrors().add(new ExceptionPackage(Severity.Severe, e));
                log.error((Object)"Error in auto discovery", e);
            }
        }
        if (report.getAddedRoots().isEmpty() && platformContainer.getSynchronizationState() == ResourceContainer.SynchronizationState.NEW) {
            report.addAddedRoot(platformResource);
        }
    }

    private List<ProcessScanResult> performProcessScans(List<ProcessInfo> processInfos, ResourceType serverType) {
        if (processInfos == null || processInfos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ProcessScanResult> scanResults = new ArrayList<ProcessScanResult>();
        Set processScans = serverType.getProcessScans();
        if (processScans != null && !processScans.isEmpty()) {
            log.debug((Object)("Executing process scans for server type " + serverType + "..."));
            ProcessInfoQuery piq = new ProcessInfoQuery(processInfos);
            for (ProcessScan processScan : processScans) {
                List queryResults = piq.query(processScan.getQuery());
                if (queryResults == null || queryResults.size() <= 0) continue;
                for (ProcessInfo autoDiscoveredProcess : queryResults) {
                    scanResults.add(new ProcessScanResult(processScan, autoDiscoveredProcess));
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Process scan auto-detected potential new server Resource: scan=[" + processScan + "], discovered-process=[" + autoDiscoveredProcess + "]"));
                }
            }
        }
        return scanResults;
    }

    private boolean verifyComponentCompatibility(ResourceDiscoveryComponent component, ResourceComponent parentResourceComponent) throws PluginContainerException {
        Method discoveryCall;
        try {
            discoveryCall = component.getClass().getMethod("discoverResources", ResourceCategory.class);
        }
        catch (NoSuchMethodException e) {
            throw new PluginContainerException("Resource component doesn't implement resource component interface", (Throwable)e);
        }
        Class<?> componentParameterType = discoveryCall.getParameterTypes()[0];
        TypeVariable<Class<?>>[] types = componentParameterType.getTypeParameters();
        if (types.length == 0) {
            return true;
        }
        TypeVariable<Class<?>> type = types[0];
        return true;
    }
}

