/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.inventory;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceError;
import org.rhq.core.domain.resource.ResourceErrorType;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pluginapi.availability.AvailabilityFacet;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;

public class AvailabilityExecutor
implements Runnable,
Callable<AvailabilityReport> {
    private static final Log LOG = LogFactory.getLog(AvailabilityExecutor.class);
    protected final InventoryManager inventoryManager;
    private final AtomicBoolean sendChangesOnlyReport;
    private static final Random RANDOM = new Random();
    private final Object lock = new Object();
    private int scanHistorySize = 1;
    private final LinkedList<Scan> scanHistory = new LinkedList();

    public AvailabilityExecutor(InventoryManager inventoryManager) {
        this.inventoryManager = inventoryManager;
        this.sendChangesOnlyReport = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object object = this.lock;
            synchronized (object) {
                AvailabilityReport report = this.call();
                this.inventoryManager.handleReport(report);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Availability report collection failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public AvailabilityReport call() throws Exception {
        AvailabilityReport availabilityReport;
        Object object = this.lock;
        synchronized (object) {
            if (this.inventoryManager.getPlatform().getInventoryStatus() != InventoryStatus.COMMITTED) {
                return null;
            }
            boolean changesOnly = this.sendChangesOnlyReport.get();
            availabilityReport = new AvailabilityReport(changesOnly, this.inventoryManager.getAgent().getName());
            if (!changesOnly) {
                this.sendChangesOnlyReportNextTime();
            }
            this.startScan(this.inventoryManager.getPlatform(), availabilityReport, changesOnly);
        }
        return availabilityReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startScan(Resource scanRoot, AvailabilityReport availabilityReport, boolean changesOnly) {
        long start = System.currentTimeMillis();
        Scan scan = new Scan(start, !changesOnly);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Scan Starting: " + new Date(start)));
        }
        AvailabilityType parentAvailabilityType = null;
        for (Resource parent = scanRoot.getParentResource(); parent != null; parent = parent.getParentResource()) {
            Availability parentAvail = this.inventoryManager.getAvailabilityIfKnown(parent);
            if (parentAvail == null || parentAvail.getAvailabilityType() != AvailabilityType.DOWN) continue;
            parentAvailabilityType = AvailabilityType.DOWN;
            break;
        }
        if (parentAvailabilityType == null) {
            parentAvailabilityType = AvailabilityType.UP;
        }
        boolean traceEnabled = LOG.isTraceEnabled();
        try {
            this.checkInventory(scanRoot, availabilityReport, parentAvailabilityType, false, scan, traceEnabled);
        }
        catch (InterruptedException e) {
            LOG.debug((Object)"Availability check was interrupted", (Throwable)e);
            return;
        }
        catch (RuntimeException e) {
            if (LOG.isDebugEnabled()) {
                if (Thread.interrupted()) {
                    LOG.debug((Object)("Exception occurred during availability check, but this thread has been interrupted, so most likely the plugin container is shutting down: " + e));
                } else {
                    LOG.debug((Object)("Exception occurred during availability check: " + e));
                }
            }
            return;
        }
        scan.setEndTime(System.currentTimeMillis());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Scan Ended   : " + new Date(scan.getEndTime()) + " : " + scan.toString()));
        }
        this.addScanHistory(scan);
        if (LOG.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            ObjectOutputStream oos = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
                oos = new ObjectOutputStream(baos);
                oos.writeObject(availabilityReport);
                LOG.debug((Object)("Built availability report for [" + availabilityReport.getResourceAvailability().size() + "] resources with a size of [" + baos.size() + "] bytes in [" + (end - start) + "]ms"));
                StreamUtil.safeClose((Closeable)oos);
            }
            catch (IOException e) {
                LOG.debug((Object)"Failed to log the availability report details.", (Throwable)e);
            }
            finally {
                StreamUtil.safeClose(oos);
            }
        }
    }

    protected void checkInventory(Resource resource, AvailabilityReport availabilityReport, AvailabilityType parentAvailType, boolean isForced, Scan scan, boolean traceEnabled) throws InterruptedException {
        boolean availChanged;
        if (resource.getId() == 0 || resource.getInventoryStatus() != InventoryStatus.COMMITTED) {
            return;
        }
        ResourceContainer resourceContainer = this.inventoryManager.getResourceContainer(resource.getId());
        if (resourceContainer == null || resourceContainer.getSynchronizationState() != ResourceContainer.SynchronizationState.SYNCHRONIZED) {
            return;
        }
        AvailabilityFacet resourceAvailabilityProxy = resourceContainer.getAvailabilityProxy();
        ++scan.numResources;
        boolean checkAvail = false;
        boolean deferToParent = false;
        long availabilityScheduleTime = resourceContainer.getAvailabilityScheduleTime();
        MeasurementScheduleRequest availScheduleRequest = resourceContainer.getAvailabilitySchedule();
        if (0L == availabilityScheduleTime || isForced) {
            if (null == availScheduleRequest) {
                if (traceEnabled) {
                    LOG.trace((Object)("No availScheduleRequest for " + resource + ". checkAvail set to true"));
                }
                checkAvail = true;
            } else if (availScheduleRequest.isEnabled()) {
                int interval = (int)availScheduleRequest.getInterval();
                availabilityScheduleTime = scan.startTime + (long)RANDOM.nextInt(interval + 1);
                resourceContainer.setAvailabilityScheduleTime(availabilityScheduleTime);
                if (traceEnabled) {
                    LOG.trace((Object)("Forced availabilityScheduleTime to " + new Date(availabilityScheduleTime) + " for " + resource));
                }
                ++scan.numScheduledRandomly;
            } else {
                if (traceEnabled) {
                    LOG.trace((Object)("Deferred availability to parent for " + resource));
                }
                deferToParent = true;
            }
        } else {
            boolean bl = checkAvail = scan.startTime >= availabilityScheduleTime;
            if (checkAvail) {
                if (traceEnabled) {
                    LOG.trace((Object)("Scheduled time has been reached for " + resource));
                }
                long interval = availScheduleRequest.getInterval();
                resourceContainer.setAvailabilityScheduleTime(scan.startTime + interval);
                ++scan.numPushedByInterval;
            } else if (traceEnabled) {
                LOG.trace((Object)("Scheduled time has not been reached for " + resource));
            }
        }
        Availability previous = this.inventoryManager.getAvailabilityIfKnown(resource);
        AvailabilityType previousType = null == previous ? AvailabilityType.UNKNOWN : previous.getAvailabilityType();
        AvailabilityType current = null;
        if (deferToParent || AvailabilityType.DOWN == parentAvailType) {
            current = parentAvailType;
            ++scan.numDeferToParent;
            if (traceEnabled) {
                LOG.trace((Object)("Gave parent availability " + parentAvailType + " to " + resource));
            }
        } else {
            if (!checkAvail && (isForced || scan.isFull && null == previous)) {
                checkAvail = true;
            }
            if (checkAvail) {
                if (traceEnabled) {
                    LOG.trace((Object)("Now checking availability for " + resource));
                }
                try {
                    ++scan.numGetAvailabilityCalls;
                    if (resourceContainer.getResourceComponentState() == ResourceContainer.ResourceComponentState.STARTED) {
                        current = this.translate(resourceAvailabilityProxy.getAvailability(), previousType);
                    } else {
                        this.inventoryManager.activateResource(resource, resourceContainer, false);
                        current = resourceContainer.getResourceComponentState() == ResourceContainer.ResourceComponentState.STARTED ? this.translate(resourceAvailabilityProxy.getAvailability(), previousType) : AvailabilityType.DOWN;
                    }
                    if (traceEnabled) {
                        LOG.trace((Object)("Current availability is " + current + " for " + resource));
                    }
                }
                catch (Throwable t) {
                    ResourceError resourceError = new ResourceError(resource, ResourceErrorType.AVAILABILITY_CHECK, t.getLocalizedMessage(), ThrowableUtil.getStackAsString((Throwable)t), System.currentTimeMillis());
                    this.inventoryManager.sendResourceErrorToServer(resourceError);
                    LOG.warn((Object)("Availability collection failed with exception on " + resource + ", availability will be reported as " + AvailabilityType.DOWN.name() + ", reason=" + t.getMessage()));
                    current = AvailabilityType.DOWN;
                }
            } else {
                current = previousType;
            }
        }
        boolean bl = availChanged = AvailabilityType.UNKNOWN != current && current != previousType;
        if (availChanged || scan.isFull) {
            Availability availability;
            if (availChanged) {
                if (traceEnabled) {
                    LOG.trace((Object)("Availability changed for " + resource));
                }
                ++scan.numAvailabilityChanges;
                availability = this.inventoryManager.updateAvailability(resource, current);
                if (!isForced && AvailabilityType.UP == current) {
                    if (traceEnabled) {
                        LOG.trace((Object)("Forcing availability check for children of " + resource));
                    }
                    isForced = true;
                }
            } else {
                availability = new Availability(resource, current);
            }
            availabilityReport.addAvailability(availability);
        }
        for (Resource child : this.inventoryManager.getContainerChildren(resource, resourceContainer)) {
            this.checkInventory(child, availabilityReport, current, isForced, scan, traceEnabled);
        }
    }

    private AvailabilityType translate(AvailabilityType current, AvailabilityType previousType) {
        return current == AvailabilityType.UNKNOWN ? previousType : current;
    }

    public void sendFullReportNextTime() {
        this.sendChangesOnlyReport.set(false);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("\nFull report requested by: " + AvailabilityExecutor.getSmallStackTrace(new Throwable())));
        }
    }

    private static String getSmallStackTrace(Throwable t) {
        StringBuilder smallStack = new StringBuilder();
        StackTraceElement[] stack = null == t ? new Exception().getStackTrace() : t.getStackTrace();
        for (int i = 1; i < stack.length; ++i) {
            StackTraceElement ste = stack[i];
            if (!ste.getClassName().startsWith("org.rhq")) continue;
            smallStack.append(ste.toString());
            smallStack.append("\n");
        }
        return smallStack.toString();
    }

    public void sendChangesOnlyReportNextTime() {
        this.sendChangesOnlyReport.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScanHistory(Scan scan) {
        LinkedList<Scan> linkedList = this.scanHistory;
        synchronized (linkedList) {
            if (this.scanHistory.size() == this.scanHistorySize) {
                this.scanHistory.removeLast();
            }
            this.scanHistory.push(scan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Scan> getScanHistory() {
        LinkedList<Scan> linkedList = this.scanHistory;
        synchronized (linkedList) {
            ArrayList<Scan> result = new ArrayList<Scan>(this.scanHistory.size());
            result.addAll(this.scanHistory);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scan getMostRecentScanHistory() {
        LinkedList<Scan> linkedList = this.scanHistory;
        synchronized (linkedList) {
            return this.scanHistory.isEmpty() ? null : this.scanHistory.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScanHistorySize(int scanHistorySize) {
        LinkedList<Scan> linkedList = this.scanHistory;
        synchronized (linkedList) {
            if (scanHistorySize < 1) {
                return;
            }
            while (this.scanHistory.size() > scanHistorySize) {
                this.scanHistory.removeLast();
            }
            this.scanHistorySize = scanHistorySize;
        }
    }

    public static class Scan {
        private final long startTime;
        private long endTime;
        private long runtime;
        private boolean isFull = false;
        private boolean isForced = false;
        int numResources = 0;
        int numGetAvailabilityCalls = 0;
        int numScheduledRandomly = 0;
        int numPushedByInterval = 0;
        int numAvailabilityChanges = 0;
        int numDeferToParent = 0;

        public Scan(long startTime, boolean isFull) {
            this.startTime = startTime;
            this.isFull = isFull;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
            this.runtime = endTime - this.startTime;
        }

        public long getRuntime() {
            return this.runtime;
        }

        public boolean isFull() {
            return this.isFull;
        }

        public boolean isForced() {
            return this.isForced;
        }

        public void setForced(boolean isForced) {
            this.isForced = isForced;
        }

        public int getNumResources() {
            return this.numResources;
        }

        public int getNumGetAvailabilityCalls() {
            return this.numGetAvailabilityCalls;
        }

        public int getNumScheduledRandomly() {
            return this.numScheduledRandomly;
        }

        public int getNumPushedByInterval() {
            return this.numPushedByInterval;
        }

        public int getNumAvailabilityChanges() {
            return this.numAvailabilityChanges;
        }

        public int getNumDeferToParent() {
            return this.numDeferToParent;
        }

        public String toString() {
            return "Scan [startTime=" + this.startTime + ", endTime=" + this.endTime + ", runtime=" + this.runtime + ", isFull=" + this.isFull + ", isForced=" + this.isForced + ", numResources=" + this.numResources + ", numGetAvailabilityCalls=" + this.numGetAvailabilityCalls + ", numScheduledRandomly=" + this.numScheduledRandomly + ", numPushedByInterval=" + this.numPushedByInterval + ", numAvailabilityChanges=" + this.numAvailabilityChanges + ", numDeferToParent=" + this.numDeferToParent + "]";
        }
    }
}

