/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.inventory;

import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.inventory.TimeoutException;
import org.rhq.core.pluginapi.availability.AvailabilityFacet;

public class AvailabilityProxy
implements AvailabilityFacet,
Callable<AvailabilityType> {
    private static final Log LOG;
    private static final int AVAIL_SYNC_TIMEOUT;
    private static final byte AVAIL_SYNC_TIMEOUT_LIMIT;
    private static final int AVAIL_ASYNC_TIMEOUT;
    private Future<AvailabilityType> availabilityFuture = null;
    private volatile Thread current;
    private long lastSubmitTime = 0L;
    private final ResourceContainer resourceContainer;
    private byte availSyncConsecutiveTimeouts = 0;

    public AvailabilityProxy(ResourceContainer resourceContainer) {
        this.resourceContainer = resourceContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AvailabilityType call() throws Exception {
        this.current = Thread.currentThread();
        ClassLoader originalContextClassLoader = this.current.getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.resourceContainer.getResourceClassLoader());
            AvailabilityType availabilityType = this.resourceContainer.getResourceComponent().getAvailability();
            return availabilityType;
        }
        finally {
            this.current.setContextClassLoader(originalContextClassLoader);
        }
    }

    public AvailabilityType getAvailability() {
        AvailabilityType avail = AvailabilityType.UNKNOWN;
        try {
            if (this.availabilityFuture != null) {
                if (this.availabilityFuture.isDone()) {
                    avail = this.availabilityFuture.get();
                } else {
                    long elapsedTime = System.currentTimeMillis() - this.lastSubmitTime;
                    if (elapsedTime > this.getAsyncTimeout()) {
                        Throwable t = new Throwable();
                        if (this.current != null) {
                            t.setStackTrace(this.current.getStackTrace());
                        }
                        String msg = "Availability check ran too long [" + elapsedTime + "ms], canceled for [" + this.resourceContainer + "]; Stack trace includes the timed out thread's stack trace.";
                        this.availabilityFuture.cancel(true);
                        this.availabilityFuture = this.resourceContainer.submitAvailabilityCheck(this);
                        this.lastSubmitTime = System.currentTimeMillis();
                        throw new TimeoutException(msg, t);
                    }
                    return this.getLastAvailabilityType();
                }
            }
            this.availabilityFuture = this.resourceContainer.submitAvailabilityCheck(this);
            this.lastSubmitTime = System.currentTimeMillis();
            if (this.availSyncConsecutiveTimeouts < this.getSyncTimeoutLimit()) {
                avail = this.availabilityFuture.get(this.getSyncTimeout(), TimeUnit.MILLISECONDS);
                this.availSyncConsecutiveTimeouts = 0;
                this.availabilityFuture = null;
            } else if (this.availSyncConsecutiveTimeouts == this.getSyncTimeoutLimit()) {
                this.availSyncConsecutiveTimeouts = (byte)(this.availSyncConsecutiveTimeouts + 1);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Disabling synchronous availability collection for [" + this.resourceContainer + "]; [" + this.getSyncTimeoutLimit() + "] consecutive timeouts exceeding [" + this.getSyncTimeout() + "ms]"));
                }
            }
        }
        catch (InterruptedException e) {
            LOG.debug((Object)"InterruptedException; shut down is (likely) in progress.");
            this.availabilityFuture.cancel(true);
            this.availabilityFuture = null;
            Thread.currentThread().interrupt();
            return AvailabilityType.UNKNOWN;
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Availability check failed", e.getCause());
        }
        catch (java.util.concurrent.TimeoutException e) {
            this.availSyncConsecutiveTimeouts = (byte)(this.availSyncConsecutiveTimeouts + 1);
        }
        return this.processAvail(avail);
    }

    private AvailabilityType processAvail(AvailabilityType type) {
        AvailabilityType result = type;
        switch (type) {
            case UP: 
            case DOWN: {
                break;
            }
            default: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ResourceComponent [" + this.resourceContainer + "] getAvailability() returned " + type + ". This is invalid and is being replaced with DOWN."));
                }
                result = AvailabilityType.DOWN;
            }
        }
        AvailabilityType lastAvail = this.getLastAvailabilityType();
        if (result != this.getLastAvailabilityType() && result == AvailabilityType.UP) {
            if (this.availSyncConsecutiveTimeouts >= this.getSyncTimeoutLimit() && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Enabling synchronous availability collection for [" + this.resourceContainer + "]; Availability has just changed from [" + lastAvail + "] to UP."));
            }
            this.availSyncConsecutiveTimeouts = 0;
        }
        return result;
    }

    private AvailabilityType getLastAvailabilityType() {
        Availability av = this.resourceContainer.getAvailability();
        if (av != null) {
            AvailabilityType avt = av.getAvailabilityType();
            return avt != null ? avt : AvailabilityType.UNKNOWN;
        }
        return AvailabilityType.UNKNOWN;
    }

    protected long getAsyncTimeout() {
        return AVAIL_ASYNC_TIMEOUT;
    }

    protected long getSyncTimeout() {
        return AVAIL_SYNC_TIMEOUT;
    }

    protected byte getSyncTimeoutLimit() {
        return AVAIL_SYNC_TIMEOUT_LIMIT;
    }

    protected boolean isSyncDisabled() {
        return this.availSyncConsecutiveTimeouts >= this.getSyncTimeoutLimit();
    }

    public String toString() {
        return "AvailabilityProxy [resource=" + this.resourceContainer + ", lastSubmitTime=" + new Date(this.lastSubmitTime) + ", availabilityFuture=" + this.availabilityFuture + ", current=" + this.current + ", timeouts=" + this.availSyncConsecutiveTimeouts + "]";
    }

    static {
        int asyncAvailTimeout;
        int syncAvailTimeoutLimit;
        int syncAvailTimeout;
        LOG = LogFactory.getLog(AvailabilityProxy.class);
        try {
            syncAvailTimeout = Integer.parseInt(System.getProperty("rhq.agent.plugins.availability-scan.sync-timeout", "1000"));
        }
        catch (Throwable t) {
            syncAvailTimeout = 1000;
        }
        AVAIL_SYNC_TIMEOUT = syncAvailTimeout;
        try {
            syncAvailTimeoutLimit = Byte.parseByte(System.getProperty("rhq.agent.plugins.availability-scan.sync-timeout-limit", "5"));
        }
        catch (Throwable t) {
            syncAvailTimeoutLimit = 5;
        }
        if (syncAvailTimeoutLimit > 127) {
            syncAvailTimeoutLimit = 127;
        }
        AVAIL_SYNC_TIMEOUT_LIMIT = (byte)syncAvailTimeoutLimit;
        try {
            asyncAvailTimeout = Integer.parseInt(System.getProperty("rhq.agent.plugins.availability-scan.async-timeout", "60000"));
        }
        catch (Throwable t) {
            asyncAvailTimeout = 60000;
        }
        AVAIL_ASYNC_TIMEOUT = asyncAvailTimeout;
    }
}

