/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.inventory;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.inventory.CreateResourceResponse;
import org.rhq.core.clientapi.server.inventory.ResourceFactoryServerService;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.inventory.ResourceFactoryManager;
import org.rhq.core.pc.inventory.TimeoutException;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.util.exception.ThrowableUtil;

public class CreateResourceRunner
implements Callable,
Runnable {
    private static final Log LOG = LogFactory.getLog(CreateResourceRunner.class);
    private static final int SERVICE_SCAN_MAX_RETRY = 10;
    private static final long SERVICE_SCAN_RETRY_PAUSE = TimeUnit.SECONDS.toMillis(30L);
    private final ResourceFactoryManager resourceFactoryManager;
    private final int parentResourceId;
    private final boolean runRuntimeScan;
    private final int requestId;
    private final CreateChildResourceFacet facet;
    private final InventoryManager inventoryManager;
    private CreateResourceReport report;

    public CreateResourceRunner(ResourceFactoryManager resourceFactoryManager, int parentResourceId, CreateChildResourceFacet facet, int requestId, CreateResourceReport report, boolean runRuntimeScan) {
        this.resourceFactoryManager = resourceFactoryManager;
        this.parentResourceId = parentResourceId;
        this.facet = facet;
        this.requestId = requestId;
        this.report = report;
        this.runRuntimeScan = runRuntimeScan;
        this.inventoryManager = PluginContainer.getInstance().getInventoryManager();
    }

    @Override
    public void run() {
        try {
            this.call();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while chaining run to call", (Throwable)e);
        }
    }

    public Object call() throws Exception {
        CreateResourceStatus status;
        String errorMessage;
        LOG.info((Object)("Creating resource through report: " + this.report));
        String resourceName = null;
        String resourceKey = null;
        Configuration configuration = null;
        try {
            Throwable throwable;
            this.report = this.facet.createResource(this.report);
            resourceName = this.report.getResourceName();
            resourceKey = this.report.getResourceKey();
            errorMessage = this.report.getErrorMessage();
            status = this.report.getStatus();
            configuration = this.report.getResourceConfiguration();
            CreateResourceStatus reportedStatus = this.report.getStatus();
            if (reportedStatus == null || reportedStatus == CreateResourceStatus.IN_PROGRESS) {
                LOG.warn((Object)("Plugin did not indicate the result of the request: " + this.requestId));
                errorMessage = "Plugin did not indicate the result of the resource creation attempt.";
                status = CreateResourceStatus.FAILURE;
            }
            if (CreateResourceRunner.isSuccessStatus(reportedStatus) && resourceKey == null) {
                LOG.warn((Object)("Plugin did not indicate the resource key for this request: " + this.requestId));
                errorMessage = "Plugin did not indicate a resource key for this request.";
                status = CreateResourceStatus.FAILURE;
            }
            if (CreateResourceRunner.isSuccessStatus(reportedStatus) && resourceName == null) {
                LOG.warn((Object)("Plugin did not indicate a resource name for the request: " + this.requestId));
                errorMessage = "Plugin did not indicate a resource name for this request.";
                status = CreateResourceStatus.FAILURE;
            }
            if ((throwable = this.report.getException()) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Throwable was found in creation report for request [" + this.requestId + "]."), throwable);
                } else {
                    LOG.warn((Object)("Throwable was found in creation report for request [" + this.requestId + "]: " + throwable + " - Enable DEBUG logging to see the stack trace."));
                }
                status = CreateResourceStatus.FAILURE;
                String messages = ThrowableUtil.getAllMessages((Throwable)throwable);
                errorMessage = errorMessage != null ? errorMessage + " - Cause: " + messages : messages;
            }
        }
        catch (TimeoutException e) {
            status = CreateResourceStatus.TIMED_OUT;
            errorMessage = "The time out has been exceeded; however, the deployment may have been successful. You may want to run a discovery scan to see if the deployment did complete successfully. Also consider using a higher time out value for future deployments.";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to create resource for " + this.report + ". " + errorMessage), (Throwable)e);
            } else {
                LOG.info((Object)("Failed to create resource for " + this.report + ". " + errorMessage), (Throwable)e);
            }
            errorMessage = errorMessage + "\n\nRoot Cause:\n" + e.getMessage();
        }
        catch (Throwable t) {
            status = CreateResourceStatus.FAILURE;
            errorMessage = ThrowableUtil.getStackAsString((Throwable)t);
        }
        CreateResourceResponse response = new CreateResourceResponse(this.requestId, resourceName, resourceKey, status, errorMessage, configuration);
        LOG.info((Object)("Sending create response to server: " + response));
        ResourceFactoryServerService serverService = this.resourceFactoryManager.getServerService();
        if (serverService != null) {
            try {
                serverService.completeCreateResource(response);
            }
            catch (Throwable throwable) {
                LOG.error((Object)("Error received while attempting to complete report for request: " + this.requestId), throwable);
            }
        }
        if (CreateResourceRunner.isSuccessStatus(status) && this.runRuntimeScan) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Scheduling service scan to discover newly created [" + this.report.getResourceType() + "] managed resource with key [" + this.report.getResourceKey() + "]..."));
            }
            Resource discoveredResource = null;
            for (int retry = 1; discoveredResource == null && retry <= 10; ++retry) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Service scan retry [" + retry + "] for parentResourceId [" + this.parentResourceId + "]"));
                }
                if (retry > 1) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Pausing for [" + SERVICE_SCAN_RETRY_PAUSE + "] ms before retrying service scan for parentResourceId [" + this.parentResourceId + "]"));
                    }
                    Thread.sleep(SERVICE_SCAN_RETRY_PAUSE);
                }
                try {
                    this.inventoryManager.performServiceScan(this.parentResourceId);
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed to run service scan to discover newly created [" + this.report.getResourceType() + "] managed resource with key [" + this.report.getResourceKey() + "]."), (Throwable)e);
                }
                discoveredResource = this.getDiscoveredResource();
                if (discoveredResource != null) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Discovered " + discoveredResource + ", for a new managed resource created via RHQ."));
                    continue;
                }
                LOG.warn((Object)("Failed to discover Resource for newly created [" + this.report.getResourceType() + "] managed resource with key [" + this.report.getResourceKey() + "]."));
            }
        }
        return response;
    }

    private static boolean isSuccessStatus(CreateResourceStatus status) {
        return status == CreateResourceStatus.SUCCESS || status == CreateResourceStatus.INVALID_CONFIGURATION || status == CreateResourceStatus.INVALID_ARTIFACT;
    }

    private Resource getDiscoveredResource() {
        ResourceContainer parentResourceContainer = this.inventoryManager.getResourceContainer(this.parentResourceId);
        Resource parentResource = parentResourceContainer.getResource();
        for (Resource childResource : parentResource.getChildResources()) {
            if (!childResource.getResourceType().equals((Object)this.report.getResourceType()) || !childResource.getResourceKey().equals(this.report.getResourceKey())) continue;
            return childResource;
        }
        return null;
    }
}

