/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.inventory;

import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.pc.inventory.AvailabilityExecutor;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;

public class CustomScanRootAvailabilityExecutor
extends AvailabilityExecutor {
    private final Resource scanRoot;
    private final boolean forceScanForRoot;

    public CustomScanRootAvailabilityExecutor(InventoryManager inventoryManager, Resource scanRoot, boolean forceScanForRoot) {
        super(inventoryManager);
        this.scanRoot = scanRoot;
        this.forceScanForRoot = forceScanForRoot;
    }

    @Override
    protected void startScan(Resource ignored, AvailabilityReport availabilityReport, boolean changesOnly) {
        if (this.forceScanForRoot) {
            ResourceContainer resourceContainer = this.inventoryManager.getResourceContainer(this.scanRoot);
            if (resourceContainer == null) {
                return;
            }
            if (resourceContainer.getResourceContext().getResourceType().getCategory() != ResourceCategory.PLATFORM) {
                resourceContainer.setAvailabilityScheduleTime(System.currentTimeMillis() - 10L);
            }
        }
        super.startScan(this.scanRoot, availabilityReport, changesOnly);
    }
}

