/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.inventory;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.THashSet;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.component.ComponentInvocationContextImpl;
import org.rhq.core.pc.inventory.AvailabilityProxy;
import org.rhq.core.pc.inventory.TimeoutException;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pc.util.LoggingThreadFactory;
import org.rhq.core.pluginapi.availability.AvailabilityFacet;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.util.exception.ThrowableUtil;

public class ResourceContainer
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String DAEMON_THREAD_POOL_NAME = "ResourceContainer.invoker.daemon";
    private static final String NON_DAEMON_THREAD_POOL_NAME = "ResourceContainer.invoker.nonDaemon";
    private static final String AVAIL_CHECK_THREAD_POOL_NAME = "ResourceContainer.invoker.availCheck.daemon";
    private static ExecutorService DAEMON_THREAD_POOL;
    private static ExecutorService NON_DAEMON_THREAD_POOL;
    private static ExecutorService AVAIL_CHECK_THREAD_POOL;
    private final Resource resource;
    private SynchronizationState synchronizationState = SynchronizationState.NEW;
    private Set<MeasurementScheduleRequest> measurementSchedule;
    private Set<ResourcePackageDetails> installedPackages;
    private Map<String, DriftDefinition> driftDefinitions;
    private MeasurementScheduleRequest availabilitySchedule = null;
    private transient ResourceComponent resourceComponent;
    private transient ResourceContext resourceContext;
    private transient ResourceComponentState resourceComponentState = ResourceComponentState.STOPPED;
    private transient ReentrantReadWriteLock facetAccessLock = new ReentrantReadWriteLock();
    private transient TIntObjectMap<Object> proxyCache = new TIntObjectHashMap(5);
    private transient ClassLoader resourceClassLoader;
    private transient AvailabilityType currentAvailType = AvailabilityType.UNKNOWN;
    private transient long currentAvailStart;
    private transient long availabilityScheduleTime;
    private transient AvailabilityProxy availabilityProxy;

    public static void initialize(PluginContainerConfiguration pcConfig) {
        LoggingThreadFactory daemonFactory = new LoggingThreadFactory(DAEMON_THREAD_POOL_NAME, true);
        LoggingThreadFactory nonDaemonFactory = new LoggingThreadFactory(NON_DAEMON_THREAD_POOL_NAME, false);
        LoggingThreadFactory availCheckFactory = new LoggingThreadFactory(AVAIL_CHECK_THREAD_POOL_NAME, true);
        DAEMON_THREAD_POOL = Executors.newCachedThreadPool(daemonFactory);
        NON_DAEMON_THREAD_POOL = Executors.newCachedThreadPool(nonDaemonFactory);
        AVAIL_CHECK_THREAD_POOL = Executors.newFixedThreadPool(pcConfig.getAvailabilityScanThreadPoolSize(), availCheckFactory);
    }

    public static void shutdown() {
        DAEMON_THREAD_POOL.shutdown();
        NON_DAEMON_THREAD_POOL.shutdown();
        AVAIL_CHECK_THREAD_POOL.shutdown();
    }

    public ResourceContainer(Resource resource, ClassLoader resourceClassLoader) {
        this.resource = resource;
        this.resourceClassLoader = resourceClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Availability updateAvailability(AvailabilityType availabilityType) {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            this.currentAvailType = availabilityType;
            this.currentAvailStart = System.currentTimeMillis();
            Availability tmp = new Availability(this.resource, availabilityType);
            tmp.setStartTime(Long.valueOf(this.currentAvailStart));
            return tmp;
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Availability getAvailability() {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            Availability tmp = new Availability(this.resource, this.currentAvailType);
            tmp.setStartTime(Long.valueOf(this.currentAvailStart));
            return tmp;
        }
    }

    public Lock getReadFacetLock() {
        return this.facetAccessLock.readLock();
    }

    public Lock getWriteFacetLock() {
        return this.facetAccessLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ResourcePackageDetails> getInstalledPackages() {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            if (this.installedPackages == null) {
                return Collections.emptySet();
            }
            return this.installedPackages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstalledPackages(Set<ResourcePackageDetails> installedPackages) {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            this.installedPackages = installedPackages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceComponent getResourceComponent() {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            return this.resourceComponent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceComponent(ResourceComponent resourceComponent) {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            this.resourceComponent = resourceComponent;
            this.availabilityProxy = new AvailabilityProxy(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceContext getResourceContext() {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            return this.resourceContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceContext(ResourceContext resourceContext) {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            this.resourceContext = resourceContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MeasurementScheduleRequest> getMeasurementSchedule() {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            if (this.measurementSchedule == null) {
                return Collections.emptySet();
            }
            return this.measurementSchedule;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMeasurementSchedule(Set<MeasurementScheduleRequest> measurementSchedule) {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            this.measurementSchedule = new THashSet(measurementSchedule);
            if (null != this.measurementSchedule) {
                for (MeasurementScheduleRequest sched : this.measurementSchedule) {
                    if (sched.getInterval() >= 30000L) continue;
                    String smallStack = ThrowableUtil.getFilteredStackAsString((Throwable)new Throwable());
                    String msg = "Invalid collection interval [" + sched + "] for Resource [" + this.resource + "]. Setting it to 20 minutes until the situation is corrected. Please report to Development: " + smallStack;
                    LogFactory.getLog(ResourceContainer.class).error((Object)msg);
                    sched.setInterval(1200000L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeasurementScheduleRequest getAvailabilitySchedule() {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            if (null == this.availabilitySchedule) {
                switch (this.resource.getResourceType().getCategory()) {
                    case PLATFORM: {
                        break;
                    }
                    case SERVER: {
                        this.availabilitySchedule = new MeasurementScheduleRequest(-1, "rhq.availability", MeasurementDefinition.AVAILABILITY_DEFAULT_PERIOD_SERVER.longValue(), true, DataType.AVAILABILITY);
                        break;
                    }
                    case SERVICE: {
                        this.availabilitySchedule = new MeasurementScheduleRequest(-1, "rhq.availability", MeasurementDefinition.AVAILABILITY_DEFAULT_PERIOD_SERVICE.longValue(), true, DataType.AVAILABILITY);
                    }
                }
            }
        }
        return this.availabilitySchedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvailabilitySchedule(MeasurementScheduleRequest availabilitySchedule) {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            this.availabilitySchedule = availabilitySchedule;
            this.availabilityScheduleTime = 0L;
        }
    }

    public long getAvailabilityScheduleTime() {
        return this.availabilityScheduleTime;
    }

    public void setAvailabilityScheduleTime(long availabilityScheduleTime) {
        this.availabilityScheduleTime = availabilityScheduleTime;
    }

    Future<AvailabilityType> submitAvailabilityCheck(Callable<AvailabilityType> callable) {
        return AVAIL_CHECK_THREAD_POOL.submit(callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateMeasurementSchedule(Set<MeasurementScheduleRequest> measurementScheduleUpdate) {
        if (null == measurementScheduleUpdate || measurementScheduleUpdate.size() == 0) {
            return false;
        }
        for (MeasurementScheduleRequest sched : measurementScheduleUpdate) {
            if (sched.getInterval() >= 30000L) continue;
            String smallStack = ThrowableUtil.getFilteredStackAsString((Throwable)new Throwable());
            String msg = "Invalid collection interval [" + sched + "] for Resource [" + this.resource + "]. Setting it to 20 minutes until the situation is corrected. Please report to Development: " + smallStack;
            LogFactory.getLog(ResourceContainer.class).error((Object)msg);
            sched.setInterval(1200000L);
        }
        HashSet<Integer> updateScheduleIds = new HashSet<Integer>();
        for (MeasurementScheduleRequest update : measurementScheduleUpdate) {
            updateScheduleIds.add(update.getScheduleId());
        }
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            if (this.measurementSchedule == null) {
                this.measurementSchedule = new HashSet<MeasurementScheduleRequest>(measurementScheduleUpdate.size());
            }
            HashSet<MeasurementScheduleRequest> toBeRemoved = new HashSet<MeasurementScheduleRequest>();
            for (MeasurementScheduleRequest current : this.measurementSchedule) {
                if (!updateScheduleIds.contains(current.getScheduleId())) continue;
                toBeRemoved.add(current);
            }
            this.measurementSchedule.removeAll(toBeRemoved);
            return this.measurementSchedule.addAll(measurementScheduleUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DriftDefinition> getDriftDefinitions() {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            if (this.driftDefinitions == null) {
                return Collections.emptyList();
            }
            return this.driftDefinitions.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDriftDefinition(DriftDefinition d) {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            if (this.driftDefinitions == null) {
                return false;
            }
            return this.driftDefinitions.containsKey(d.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDriftDefinition(DriftDefinition d) {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            if (this.driftDefinitions == null) {
                this.driftDefinitions = new HashMap<String, DriftDefinition>(1);
            }
            this.driftDefinitions.put(d.getName(), d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDriftDefinition(DriftDefinition d) {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            if (this.driftDefinitions != null) {
                this.driftDefinitions.remove(d.getName());
                if (this.driftDefinitions.isEmpty()) {
                    this.driftDefinitions = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceComponentState getResourceComponentState() {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            return this.resourceComponentState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceComponentState(ResourceComponentState state) {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            this.resourceComponentState = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizationState getSynchronizationState() {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            return this.synchronizationState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizationState(SynchronizationState synchronizationState) {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            this.synchronizationState = synchronizationState;
        }
    }

    public ClassLoader getResourceClassLoader() {
        return this.resourceClassLoader;
    }

    public void setResourceClassLoader(ClassLoader resourceClassLoader) {
        this.resourceClassLoader = resourceClassLoader;
    }

    public String toString() {
        AvailabilityType avail = this.currentAvailType != null ? this.currentAvailType : null;
        return this.getClass().getSimpleName() + "[resource=" + this.resource + ", syncState=" + (Object)((Object)this.synchronizationState) + ", componentState=" + (Object)((Object)this.resourceComponentState) + ", avail=" + avail + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T createResourceComponentProxy(Class<T> facetInterface, FacetLockType lockType, long timeout, boolean daemonThread, boolean onlyIfStarted, boolean transferInterrupt) throws PluginContainerException {
        if (onlyIfStarted && !ResourceComponentState.STARTED.equals((Object)this.getResourceComponentState())) {
            throw new PluginContainerException("Resource component could not be retrieved for resource [" + this.getResource() + "] because the component is not started. Its state is [" + (Object)((Object)this.getResourceComponentState()) + "]");
        }
        ResourceComponent resourceComponent = this.getResourceComponent();
        if (resourceComponent == null) {
            throw new PluginContainerException("Component does not exist for resource: " + this.getResource());
        }
        if (!facetInterface.isAssignableFrom(resourceComponent.getClass())) {
            throw new PluginContainerException("Component does not support the [" + facetInterface.getName() + "] interface: " + this);
        }
        if (lockType == FacetLockType.NONE && timeout == 0L) {
            return (T)resourceComponent;
        }
        int key = facetInterface.hashCode();
        key = 31 * key + lockType.hashCode();
        key = 31 * key + (int)(timeout ^ timeout >>> 32);
        key = 31 * key + (daemonThread ? 1 : 0);
        key = 31 * key + (transferInterrupt ? 1 : 0);
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            Object proxy;
            if (this.proxyCache == null) {
                this.proxyCache = new TIntObjectHashMap(5);
            }
            if ((proxy = this.proxyCache.get(key)) == null) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                ResourceComponentInvocationHandler handler = new ResourceComponentInvocationHandler(this, lockType, timeout, daemonThread, facetInterface, transferInterrupt);
                proxy = Proxy.newProxyInstance(classLoader, new Class[]{facetInterface}, (InvocationHandler)handler);
                this.proxyCache.put(key, proxy);
            }
            return (T)proxy;
        }
    }

    public boolean supportsFacet(Class facetInterface) {
        ResourceComponent thisComponent = this.getResourceComponent();
        if (thisComponent == null) {
            return false;
        }
        return facetInterface.isAssignableFrom(thisComponent.getClass());
    }

    private String getFacetLockStatus() {
        StringBuilder str = new StringBuilder("Facet lock status for [");
        str.append(this.getResource());
        str.append("], is-write-locked=[").append(this.facetAccessLock.isWriteLocked());
        str.append("], is-write-locked-by-current-thread=[").append(this.facetAccessLock.isWriteLockedByCurrentThread());
        str.append("], read-locks=[").append(this.facetAccessLock.getReadLockCount());
        str.append("], waiting-for-lock-queue-size=[").append(this.facetAccessLock.getQueueLength());
        str.append("]");
        return str.toString();
    }

    private Object readResolve() throws ObjectStreamException {
        this.facetAccessLock = new ReentrantReadWriteLock();
        return this;
    }

    public AvailabilityFacet getAvailabilityProxy() {
        return this.availabilityProxy;
    }

    private static class ComponentInvocation
    implements Callable {
        private static final Log LOG = LogFactory.getLog(ComponentInvocation.class);
        private final ResourceContainer resourceContainer;
        private final Method method;
        private final Object[] args;
        private final Lock lock;
        private final ComponentInvocationContextImpl componentInvocationContext;
        private final ComponentInvocationContextImpl.LocalContext localContext;
        private volatile Thread thread;

        ComponentInvocation(ResourceContainer resourceContainer, Method method, Object[] args, Lock lock) {
            this.resourceContainer = resourceContainer;
            this.method = method;
            this.args = args;
            this.lock = lock;
            this.componentInvocationContext = (ComponentInvocationContextImpl)resourceContainer.getResourceContext().getComponentInvocationContext();
            this.localContext = new ComponentInvocationContextImpl.LocalContext();
        }

        public StackTraceElement[] getStackTrace() throws Exception {
            if (this.thread == null) {
                return new StackTraceElement[0];
            }
            return this.thread.getStackTrace();
        }

        public Object call() throws Exception {
            this.thread = Thread.currentThread();
            if (this.lock != null) {
                try {
                    this.lock.lockInterruptibly();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
            this.componentInvocationContext.setLocalContext(this.localContext);
            ClassLoader originalContextClassLoader = this.thread.getContextClassLoader();
            try {
                ClassLoader pluginClassLoader = this.resourceContainer.getResourceClassLoader();
                if (pluginClassLoader == null) {
                    throw new IllegalStateException("No plugin class loader was specified for " + this + ".");
                }
                this.thread.setContextClassLoader(pluginClassLoader);
                ResourceComponent resourceComponent = this.resourceContainer.getResourceComponent();
                Object object = this.method.invoke((Object)resourceComponent, this.args);
                return object;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw cause instanceof Exception ? (Exception)cause : new Exception(cause);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (this.lock != null) {
                    this.lock.unlock();
                }
                this.thread.setContextClassLoader(originalContextClassLoader);
                this.thread = null;
            }
        }

        public void markContextInterrupted() {
            this.localContext.markInterrupted();
            LOG.warn((Object)this.getContextInterruptedWarningMessage(LOG.isDebugEnabled()));
        }

        private String getContextInterruptedWarningMessage(boolean detailed) {
            StringBuilder sb = new StringBuilder();
            sb.append("Invocation has been marked interrupted for method [");
            if (detailed) {
                sb.append(this.method.toGenericString());
            } else {
                sb.append(this.method.getDeclaringClass().getSimpleName()).append(".").append(this.method.getName());
            }
            sb.append("] on resource [").append(this.resourceContainer.getResource()).append("]");
            return sb.toString();
        }
    }

    private static class ResourceComponentInvocationHandler
    implements InvocationHandler {
        private static final Log LOG = LogFactory.getLog(ResourceComponentInvocationHandler.class);
        private final ResourceContainer container;
        private final Lock lock;
        private final int timeoutInSeconds;
        private final boolean daemonThread;
        private final Class facetInterface;
        private final boolean transferInterrupt;

        public ResourceComponentInvocationHandler(ResourceContainer container, FacetLockType lockType, long timeout, boolean daemonThread, Class facetInterface, boolean transferInterrupt) {
            this.container = container;
            switch (lockType) {
                case WRITE: {
                    this.lock = container.getWriteFacetLock();
                    break;
                }
                case READ: {
                    this.lock = container.getReadFacetLock();
                    break;
                }
                default: {
                    this.lock = null;
                }
            }
            if (timeout <= 0L) {
                throw new IllegalArgumentException("timeout value is not positive.");
            }
            this.timeoutInSeconds = (int)((timeout + 999L) / 1000L);
            this.daemonThread = daemonThread;
            this.facetInterface = facetInterface;
            this.transferInterrupt = transferInterrupt;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass().equals(this.facetInterface)) {
                return this.invokeInNewThreadWithLock(method, args);
            }
            return this.invokeInCurrentThreadWithoutLock(method, args);
        }

        private Object invokeInNewThreadWithLock(Method method, Object[] args) throws Throwable {
            ExecutorService threadPool = this.daemonThread ? DAEMON_THREAD_POOL : NON_DAEMON_THREAD_POOL;
            ComponentInvocation componentInvocation = new ComponentInvocation(this.container, method, args, this.lock);
            Future future = threadPool.submit(componentInvocation);
            try {
                return future.get(this.timeoutInSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.error((Object)("Thread [" + Thread.currentThread().getName() + "] was interrupted."));
                if (this.transferInterrupt) {
                    future.cancel(true);
                    componentInvocation.markContextInterrupted();
                }
                throw new RuntimeException(this.invokedMethodString(method, args, "was rudely interrupted."), e);
            }
            catch (ExecutionException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)this.invokedMethodString(method, args, "failed."), (Throwable)e);
                }
                throw e.getCause();
            }
            catch (java.util.concurrent.TimeoutException e) {
                String msg = this.invokedMethodString(method, args, "timed out after " + this.timeoutInSeconds + " seconds - invocation thread will be interrupted.");
                LOG.debug((Object)msg);
                Throwable cause = new Throwable();
                cause.setStackTrace(componentInvocation.getStackTrace());
                future.cancel(true);
                componentInvocation.markContextInterrupted();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)this.container.getFacetLockStatus());
                }
                throw new TimeoutException(msg).initCause(cause);
            }
        }

        private String invokedMethodString(Method method, Object[] methodArgs, String extraMsg) {
            String name = this.container.getResourceComponent().getClass().getName() + '.' + method.getName() + "()";
            String args = methodArgs != null ? Arrays.asList(methodArgs).toString() : "";
            return "Call to [" + name + "] with args [" + args + "] " + extraMsg;
        }

        private Object invokeInCurrentThreadWithoutLock(Method method, Object[] args) throws Throwable {
            Thread thread = Thread.currentThread();
            ClassLoader originalContextClassLoader = thread.getContextClassLoader();
            try {
                ClassLoader pluginClassLoader = this.container.getResourceClassLoader();
                if (pluginClassLoader == null) {
                    throw new IllegalStateException("No plugin classloader was specified for " + this + ".");
                }
                thread.setContextClassLoader(pluginClassLoader);
                Object object = method.invoke((Object)this.container.getResourceComponent(), args);
                return object;
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause() != null ? ite.getCause() : ite;
            }
            finally {
                thread.setContextClassLoader(originalContextClassLoader);
            }
        }
    }

    public static enum ResourceComponentState {
        STARTED,
        STOPPED,
        STARTING;

    }

    public static enum SynchronizationState {
        NEW,
        SYNCHRONIZED,
        DELETED_ON_AGENT,
        DELETED_ON_SERVER;

    }
}

