/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.inventory;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.inventory.CreateResourceRequest;
import org.rhq.core.clientapi.agent.inventory.CreateResourceResponse;
import org.rhq.core.clientapi.agent.inventory.DeleteResourceRequest;
import org.rhq.core.clientapi.agent.inventory.DeleteResourceResponse;
import org.rhq.core.clientapi.agent.inventory.ResourceFactoryAgentService;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataManager;
import org.rhq.core.clientapi.server.inventory.ResourceFactoryServerService;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.ContainerService;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.ServerServices;
import org.rhq.core.pc.agent.AgentService;
import org.rhq.core.pc.agent.AgentServiceStreamRemoter;
import org.rhq.core.pc.inventory.CreateResourceRunner;
import org.rhq.core.pc.inventory.DeleteResourceRunner;
import org.rhq.core.pc.plugin.PluginManager;
import org.rhq.core.pc.util.ComponentUtil;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pc.util.LoggingThreadFactory;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;

public class ResourceFactoryManager
extends AgentService
implements ContainerService,
ResourceFactoryAgentService {
    private static final Log log;
    private static final int FACET_CREATE_TIMEOUT;
    private static final int FACET_DELETE_TIMEOUT;
    private final PluginContainerConfiguration configuration;
    private final ExecutorService executor;
    private final PluginMetadataManager metadataManager;

    public ResourceFactoryManager(PluginContainerConfiguration configuration, AgentServiceStreamRemoter streamRemoter, PluginManager pluginManager) {
        super(ResourceFactoryAgentService.class, streamRemoter);
        log.debug((Object)"Initializing...");
        this.configuration = configuration;
        this.metadataManager = pluginManager.getMetadataManager();
        int corePoolSize = configuration.getResourceFactoryCoreThreadPoolSize();
        int keepAliveTime = configuration.getResourceFactoryKeepAliveTime();
        int maxPoolSize = configuration.getResourceFactoryMaxThreadPoolSize();
        this.executor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, (long)keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10000), new LoggingThreadFactory("ResourceFactory.executor", true));
    }

    @Override
    public void shutdown() {
        PluginContainer.shutdownExecutorService(this.executor, false);
    }

    public CreateResourceResponse executeCreateResourceImmediately(CreateResourceRequest request) throws PluginContainerException {
        CreateResourceResponse response;
        ResourceType resourceType = this.metadataManager.getType(request.getResourceTypeName(), request.getPluginName());
        if (resourceType == null) {
            throw new PluginContainerException("Could not retrieve resource type for request: " + request);
        }
        String creationType = request.getResourceConfiguration() != null ? "configuration" : "package";
        log.debug((Object)("Creating " + creationType + "-based resource of type '" + request.getResourceTypeName() + "' and with parent with id " + request.getParentResourceId() + "..."));
        CreateResourceReport report = new CreateResourceReport(request.getResourceName(), resourceType, request.getPluginConfiguration(), request.getResourceConfiguration(), request.getPackageDetails());
        CreateChildResourceFacet facet = this.getCreateChildResourceFacet(request.getParentResourceId(), request.getTimeout());
        CreateResourceRunner runner = new CreateResourceRunner(this, request.getParentResourceId(), facet, request.getRequestId(), report, this.configuration.isInsideAgent());
        try {
            response = (CreateResourceResponse)this.executor.submit(runner).get();
        }
        catch (Exception e) {
            throw new PluginContainerException("Error during create resource callable", (Throwable)e);
        }
        return response;
    }

    public void createResource(CreateResourceRequest request) throws PluginContainerException {
        ResourceType resourceType = this.metadataManager.getType(request.getResourceTypeName(), request.getPluginName());
        if (resourceType == null) {
            throw new PluginContainerException("Could not retrieve resource type for request: " + request);
        }
        String creationType = request.getResourceConfiguration() != null ? "configuration" : "package";
        log.debug((Object)("Creating " + creationType + "-based resource of type '" + request.getResourceTypeName() + "' and with parent with id " + request.getParentResourceId() + "..."));
        CreateResourceReport report = new CreateResourceReport(request.getResourceName(), resourceType, request.getPluginConfiguration(), request.getResourceConfiguration(), request.getPackageDetails());
        CreateChildResourceFacet facet = this.getCreateChildResourceFacet(request.getParentResourceId(), request.getTimeout());
        CreateResourceRunner runner = new CreateResourceRunner(this, request.getParentResourceId(), facet, request.getRequestId(), report, this.configuration.isInsideAgent());
        this.executor.submit(runner);
    }

    public DeleteResourceResponse executeDeleteResourceImmediately(DeleteResourceRequest request) throws PluginContainerException {
        DeleteResourceResponse response;
        int resourceId = request.getResourceId();
        DeleteResourceFacet facet = this.getDeleteResourceFacet(resourceId);
        DeleteResourceRunner runner = new DeleteResourceRunner(this, facet, request.getRequestId(), resourceId);
        try {
            response = (DeleteResourceResponse)this.executor.submit(runner).get();
        }
        catch (Exception e) {
            throw new PluginContainerException("Error occurred in delete resource thread", (Throwable)e);
        }
        return response;
    }

    public void deleteResource(DeleteResourceRequest request) throws PluginContainerException {
        int resourceId = request.getResourceId();
        DeleteResourceFacet facet = this.getDeleteResourceFacet(resourceId);
        DeleteResourceRunner runner = new DeleteResourceRunner(this, facet, request.getRequestId(), resourceId);
        this.executor.submit(runner);
    }

    ResourceFactoryServerService getServerService() {
        ServerServices serverServices = this.configuration.getServerServices();
        if (serverServices == null) {
            return null;
        }
        ResourceFactoryServerService resourceFactoryServerService = serverServices.getResourceFactoryServerService();
        return resourceFactoryServerService;
    }

    private DeleteResourceFacet getDeleteResourceFacet(int resourceId) throws PluginContainerException {
        DeleteResourceFacet facet = ComponentUtil.getComponent(resourceId, DeleteResourceFacet.class, FacetLockType.WRITE, FACET_DELETE_TIMEOUT, false, true, false);
        return facet;
    }

    private CreateChildResourceFacet getCreateChildResourceFacet(int parentResourceId, Integer timeout) throws PluginContainerException {
        int createTimeout = null == timeout || timeout < 1 ? FACET_CREATE_TIMEOUT : timeout;
        CreateChildResourceFacet facet = ComponentUtil.getComponent(parentResourceId, CreateChildResourceFacet.class, FacetLockType.WRITE, createTimeout, false, true, false);
        return facet;
    }

    static {
        int timeout;
        log = LogFactory.getLog(ResourceFactoryManager.class);
        try {
            timeout = Integer.parseInt(System.getProperty("rhq.agent.plugins.facet.create-child-resource.timeout", "60000"));
        }
        catch (Throwable t) {
            timeout = 60000;
        }
        FACET_CREATE_TIMEOUT = timeout;
        try {
            timeout = Integer.parseInt(System.getProperty("rhq.agent.plugins.facet.delete-resource.timeout", "60000"));
        }
        catch (Throwable t) {
            timeout = 60000;
        }
        FACET_DELETE_TIMEOUT = timeout;
    }
}

